/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.base.service;

import itx.erp.ErpObjectContainer;
import itx.erp.base.model.Activity;
import itx.erp.base.model.ActivityValue;
import itx.erp.base.service.ErpServiceBase;
import itx.erp.customer.service.CustomerService;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import jtbcore.db.common.QueryBuilder;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.InvalidStateException;
import jtbcore.model.BaseStringMap;
import jtbcore.util.MapUtil;
import jtbcore.util.NumberUtil;

public class ActivityService
extends ErpServiceBase {
    public QueryResult<Activity> searchActivity(Map<String, Object> opts) throws SQLException, InvalidStateException {
        Integer start = (Integer)opts.get("start");
        Integer pageSize = (Integer)opts.get("pageSize");
        QueryBuilder b = new QueryBuilder(this.connection);
        b.setTable("base__activity");
        b.addSelectField("activity_id");
        b.addSelectField("customer_id");
        b.addSelectField("ref_object");
        b.addSelectField("ref_id");
        b.addSelectField("user_id");
        b.addSelectField("username");
        b.addSelectField("code");
        b.addSelectField("short_description");
        b.addSelectField("created");
        if (MapUtil.hasProperty(opts, "shortDescription")) {
            b.addWhere("short_description LIKE ?", "%" + String.valueOf(opts.get("shortDescription")) + "%");
        }
        if (MapUtil.hasProperty(opts, "refObject")) {
            b.addWhere("ref_object LIKE ?", "%" + String.valueOf(opts.get("refObject")) + "%");
        }
        if (opts.get("refId") instanceof Integer) {
            b.addWhere("ref_id = ?", (Integer)opts.get("refId"));
        }
        if (MapUtil.hasProperty(opts, "username")) {
            b.addWhere("username LIKE ?", "%" + String.valueOf(opts.get("username")) + "%");
        }
        b.setOffset(start);
        b.setLimit(pageSize);
        b.setRawOrderBy("activity_id desc");
        Integer rowCount = b.queryCount();
        ResultSet rs = b.queryResultSet();
        QueryResult<Activity> t = new QueryResult<Activity>();
        t.fill(Activity.class, rs);
        t.setStart(start);
        t.setPageSize(pageSize);
        t.setRowCount(rowCount);
        return t;
    }

    public Activity readActivity(Integer activityId) throws SQLException {
        BaseStringMap bsm = this.connection.queryBsm("select * from base__activity where activity_id = ?", activityId);
        Activity a = new Activity();
        a.setBaseStringMap(bsm);
        List<BaseStringMap> bsmvals = this.connection.queryBsmList("select * from base__activity_value where activity_id = ?", activityId);
        for (BaseStringMap bsmv : bsmvals) {
            ActivityValue av = new ActivityValue();
            av.setBaseStringMap(bsmv);
            a.getValues().add(av);
            if (!"customerId".equals(av.getRefField())) continue;
            Integer oldId = NumberUtil.tryParseInt(av.getOldValue());
            Integer newId = NumberUtil.tryParseInt(av.getNewValue());
            try {
                CustomerService customerService = ErpObjectContainer.getInstance().getCustomerService();
                Object oldName = customerService.getCustomerName(oldId);
                Object newName = customerService.getCustomerName(newId);
                if (oldName == null && oldId != null) {
                    oldName = "customer-" + String.valueOf(oldId);
                }
                if (newName == null && newId != null) {
                    newName = "custmer-" + String.valueOf(newId);
                }
                if (oldName == null && newName == null) continue;
                ActivityValue avcustomer = new ActivityValue();
                avcustomer.setRefField("customerName");
                avcustomer.setOldValue((String)oldName);
                avcustomer.setNewValue((String)newName);
                a.getValues().add(avcustomer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return a;
    }

    public void createActivity(Integer userId, String code, String shortDescription, String longDescription) throws IOException, SQLException {
        String username = (String)this.connection.queryValue("select username from base__user where user_id = ?", String.class, userId);
        Activity a = new Activity();
        a.setUserId(userId);
        a.setUsername(username);
        a.setCode(code);
        a.setShortDescription(shortDescription);
        a.setLongDescription(longDescription);
        this.connection.save("base__activity", "activity_id", a);
    }

    public void createActivityRef(Integer userId, String refObject, Integer refId, String code, String shortDescription, String longDescription) throws IOException, SQLException {
        String username = (String)this.connection.queryValue("select username from base__user where user_id = ?", String.class, userId);
        Activity a = new Activity();
        a.setUserId(userId);
        a.setUsername(username);
        a.setRefObject(refObject);
        a.setRefId(refId);
        a.setCode(code);
        a.setShortDescription(shortDescription);
        a.setLongDescription(longDescription);
        this.connection.save("base__activity", "activity_id", a);
    }
}

