/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.base.service;

import itx.erp.base.model.Activity;
import itx.erp.base.model.UserGroup;
import itx.erp.base.service.ErpServiceBase;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jtbcore.db.common.QueryBuilder;
import jtbcore.db.common.QueryResult;
import jtbcore.db.common.SqlConnection;
import jtbcore.exception.JTBException;
import jtbcore.model.BaseStringMap;
import jtbcore.util.MapUtil;

public class GroupService
extends ErpServiceBase {
    final String[] groupLogFields = new String[]{"groupName", "defaultSelected"};

    public void saveGroup(UserGroup ug, Integer loggedin_userId) throws IOException, SQLException {
        boolean isNew = ug.getUserGroupId() == null;
        UserGroup old_ug = null;
        if (!isNew) {
            old_ug = this.readGroup(ug.getUserGroupId());
        }
        this.connection.save("base__user_group", "user_group_id", ug);
        Activity a = new Activity();
        a.setRefObject(UserGroup.class.getName());
        a.setRefId(ug.getUserGroupId());
        if (loggedin_userId != null) {
            a.setUserId(loggedin_userId);
        }
        if (isNew) {
            a.setCode("group-created");
            a.setShortDescription("Group created: " + ug.getGroupName());
            a.logNew(ug, this.groupLogFields);
        } else {
            a.setCode("group-edited");
            a.setShortDescription("Group renamed: " + old_ug.getGroupName() + " => " + ug.getGroupName());
            a.logChange(old_ug, ug, this.groupLogFields);
        }
        this.saveActivity(a);
    }

    public void deleteGroup(Integer userGroupId, Integer loggedin_userId) throws SQLException, IOException {
        UserGroup g = this.readGroup(userGroupId);
        Activity a = new Activity();
        a.setRefObject(UserGroup.class.getName());
        a.setRefId(g.getUserGroupId());
        if (loggedin_userId != null) {
            a.setUserId(loggedin_userId);
        }
        a.setCode("group-deleted");
        a.setShortDescription("Group deleted: " + g.getGroupName());
        a.logDelete(g, this.groupLogFields);
        this.saveActivity(a);
        this.connection.query("delete from base__user_group      where user_group_id = ?", userGroupId);
        this.connection.query("delete from base__user_group_link where user_group_id = ?", userGroupId);
        this.connection.query("delete from base__user_permission where group_id = ?", userGroupId);
        this.connection.query("delete from base__capability      where user_group_id = ?", userGroupId);
    }

    public List<UserGroup> readAll() throws SQLException {
        List l = this.connection.queryList("select * from base__user_group order by sort, user_group_id", new Object[0]);
        ArrayList<UserGroup> r = new ArrayList<UserGroup>();
        for (BaseStringMap bsm : l) {
            UserGroup ug = new UserGroup();
            ug.setBaseStringMap(bsm);
            r.add(ug);
        }
        return r;
    }

    public UserGroup readGroup(Integer userGroupId) throws SQLException {
        QueryBuilder b = new QueryBuilder(this.connection);
        b.setTable("base__user_group");
        b.addSelectField("user_group_id");
        b.addSelectField("group_name");
        b.addSelectField("default_selected");
        b.addSelectField("edited");
        b.addSelectField("created");
        b.addWhere("user_group_id = ?", userGroupId);
        ResultSet rs = b.queryResultSet();
        if (!rs.next()) {
            return null;
        }
        BaseStringMap bsm = SqlConnection.resultSet2StringMap(rs);
        rs.close();
        UserGroup ug = new UserGroup();
        ug.setBaseStringMap(bsm);
        return ug;
    }

    public QueryResult<UserGroup> searchGroups(Map<String, Object> opts) throws SQLException {
        QueryBuilder b = new QueryBuilder(this.connection);
        b.setTable("base__user_group");
        b.addSelectField("user_group_id");
        b.addSelectField("group_name");
        b.addSelectField("default_selected");
        b.addSelectField("sort");
        b.addSelectField("edited");
        b.addSelectField("created");
        if (MapUtil.hasProperty(opts, "group_name")) {
            b.addWhere("group_name = ?", opts.get("group_name").toString());
        }
        b.setRawOrderBy("sort asc, user_group_id asc");
        ResultSet rs = b.queryResultSet();
        QueryResult<UserGroup> t = new QueryResult<UserGroup>();
        t.fill(UserGroup.class, rs, opts);
        return t;
    }

    public void updateSort(Integer userGroupId, Integer sort) throws SQLException {
        this.connection.query("update base__user_group set sort = ? where user_group_id = ?", sort, userGroupId);
    }

    public List<UserGroup> readDefaultSelected() throws SQLException, JTBException {
        String sql = "SELECT *  FROM base__user_group where default_selected = true order by sort, created";
        List ugs = this.queryToList(UserGroup.class, sql, new Object[0]);
        return ugs;
    }
}

