/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.base.service;

import itx.erp.base.model.Activity;
import itx.erp.base.model.User;
import itx.erp.base.model.UserGroup;
import itx.erp.base.model.UserPermission;
import itx.erp.base.service.ErpServiceBase;
import itx.erp.helper.ErpConfig;
import itx.erp.webmail.model.EmailMessage;
import itx.erp.webmail.model.EmailTemplate;
import itx.erp.webmail.model.ResetPassword;
import itx.erp.webmail.service.EmailService;
import itx.erp.webmail.service.EmailTemplateService;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import jtbcore.db.common.QueryBuilder;
import jtbcore.db.common.QueryResult;
import jtbcore.db.common.SqlConnection;
import jtbcore.exception.InvalidStateException;
import jtbcore.exception.JTBException;
import jtbcore.exception.RemoteApiException;
import jtbcore.model.BaseStringMap;
import jtbcore.util.CryptUtil;
import jtbcore.util.NumberUtil;
import jtbcore.util.StringUtil;
import org.apache.commons.validator.EmailValidator;

public class UserService
extends ErpServiceBase {
    final String[] userLogFields = new String[]{"activated", "userType", "username", "email", "firstname", "lastname", "userGroupNames"};
    protected ErpConfig appConfig;
    protected EmailService emailService;
    protected EmailTemplateService emailTemplateService;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public EmailService getEmailService() {
        return this.emailService;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public EmailTemplateService getEmailTemplateService() {
        return this.emailTemplateService;
    }

    public void setEmailTemplateService(EmailTemplateService emailTemplateService) {
        this.emailTemplateService = emailTemplateService;
    }

    public void saveUser(User u, Integer loggedIn_userId) throws IOException, SQLException {
        User old_user = null;
        if (u.getUserId() != null) {
            old_user = this.readUser(u.getUserId());
        }
        this.connection.save("base__user", "user_id", u);
        this.connection.saveMTM("base__user_group_link", "user_id", u.getUserId(), "user_group_id", u.getGroup());
        for (UserPermission up : u.getPermissions()) {
            Integer upid = (Integer)this.connection.queryValue("select user_permission_id from base__user_permission where user_id = ? and ref_object = ?", Integer.class, u.getUserId(), up.getRefObject());
            if (upid != null) {
                up.setUserPermissionId(upid);
            }
            up.setUserId(u.getUserId());
            this.connection.save("base__user_permission", "user_permission_id", up);
        }
        Activity a = new Activity();
        a.setRefObject(User.class.getName());
        a.setRefId(u.getUserId());
        if (loggedIn_userId != null) {
            a.setUserId(loggedIn_userId);
        }
        if (old_user != null) {
            a.setCode("user-updated");
            a.setShortDescription("User updated: " + u.getUsername());
            a.logChange(old_user, u, this.userLogFields);
            if (u.getPassword() != null) {
                a.addValue("password", "?", "changed");
            }
        } else {
            a.setCode("user-created");
            a.setShortDescription("User created: " + u.getUsername());
            a.logNew(u, this.userLogFields);
        }
        this.saveActivity(a);
        this.updateUserLog();
    }

    public User readUser(String username) throws SQLException {
        if (username == null) {
            return null;
        }
        Integer userId = (Integer)this.connection.queryValue("select user_id from base__user where lower(username) = ?", Integer.class, username.toLowerCase());
        if (userId != null) {
            return this.readUser(userId);
        }
        return null;
    }

    public List<User> readByEmail(String email) throws SQLException {
        if (email == null || email.trim().length() == 0) {
            return new ArrayList<User>();
        }
        List recs = this.connection.queryList("select user_id from base__user where lower(email) = ?", email);
        ArrayList<User> result = new ArrayList<User>();
        for (BaseStringMap rec : recs) {
            User u = this.readUser(rec.getPropertyInt("user_id"));
            result.add(u);
        }
        return result;
    }

    public String readPassword(Integer userId) throws SQLException {
        if (userId == null) {
            return null;
        }
        String p = (String)this.connection.queryValue("select password from base__user where user_id = ?", String.class, userId);
        return p;
    }

    public User readUser(Integer userId) throws SQLException {
        QueryBuilder b = new QueryBuilder(this.connection);
        b.setTable("base__user");
        b.addSelectField("user_id");
        b.addSelectField("username");
        b.addSelectField("user_type");
        b.addSelectField("email");
        b.addSelectField("firstname");
        b.addSelectField("lastname");
        b.addSelectField("activated");
        b.addSelectField("edited");
        b.addSelectField("created");
        b.addWhere("user_id = ?", userId);
        ResultSet rs = b.queryResultSet();
        if (!rs.next()) {
            rs.close();
            return null;
        }
        BaseStringMap bsm = SqlConnection.resultSet2StringMap(rs);
        rs.close();
        User u = new User();
        u.setBaseStringMap(bsm);
        List<UserGroup> ugs = this.readGroupsByUser(u.getUserId());
        u.setGroups(ugs);
        List<UserPermission> ups = this.readPermissionsByUser(u.getUserId());
        u.setPermissions(ups);
        return u;
    }

    public List<UserPermission> readPermissionsByUser(Integer userId) throws SQLException {
        QueryBuilder b = new QueryBuilder(this.connection);
        b.setTable("base__user_permission");
        b.addSelectField("user_permission_id");
        b.addSelectField("user_id");
        b.addSelectField("group_id");
        b.addSelectField("ref_object");
        b.addSelectField("ref_id");
        b.addSelectField("access_method");
        b.addWhere("base__user_permission.user_id = ?", userId);
        b.addWhere("base__user_permission.ref_id is null", new Object[0]);
        b.addWhere("base__user_permission.group_id is null", new Object[0]);
        ResultSet rs = b.queryResultSet();
        QueryResult t = new QueryResult();
        t.fill(UserPermission.class, rs);
        return t.getObjects();
    }

    public List<UserGroup> readGroupsByUser(Integer userId) throws SQLException {
        QueryBuilder b = new QueryBuilder(this.connection);
        b.setTable("base__user_group");
        b.addJoin("base__user_group_link", "base__user_group_link.user_group_id = base__user_group.user_group_id", null);
        b.addSelectField("base__user_group", "user_group_id");
        b.addSelectField("group_name");
        b.addSelectField("edited");
        b.addSelectField("created");
        b.addWhere("base__user_group_link.user_id = ?", userId);
        ResultSet rs = b.queryResultSet();
        QueryResult t = new QueryResult();
        t.fill(UserGroup.class, rs);
        return t.getObjects();
    }

    public void deleteUser(User u, Integer loggedIn_userId) throws SQLException, InvalidStateException, IOException {
        if ("admin".equals((u = this.readUser(u.getUserId())).getUsername())) {
            throw new InvalidStateException("Unable to delete admin");
        }
        this.connection.query("delete from base__capability where user_id = ?", u.getUserId());
        this.connection.query("delete from base__user_permission where user_id = ?", u.getUserId());
        this.connection.query("delete from base__user_group_link where user_id = ?", u.getUserId());
        this.connection.query("delete from base__web_session where user_id = ?", u.getUserId());
        this.connection.query("delete from base__user where user_id = ?", u.getUserId());
        Activity a = new Activity();
        a.setRefObject(User.class.getName());
        a.setRefId(u.getUserId());
        if (loggedIn_userId != null) {
            a.setUserId(loggedIn_userId);
        }
        a.setCode("user-deleted");
        a.setShortDescription("User deleted: " + u.getUsername());
        a.logDelete(u, this.userLogFields);
        this.saveActivity(a);
        this.updateUserLog();
    }

    public QueryResult<User> searchUsers(Map<String, Object> opts) throws SQLException {
        QueryBuilder b = new QueryBuilder(this.connection);
        b.setTable("base__user");
        b.addSelectField("user_id");
        b.addSelectField("username");
        b.addSelectField("email");
        b.addSelectField("firstname");
        b.addSelectField("lastname");
        b.addSelectField("activated");
        b.addSelectField("edited");
        b.addSelectField("created");
        if (opts != null) {
            if (opts.containsKey("username")) {
                b.addWhere("username = ?", opts.get("username").toString());
            }
            if (!StringUtil.isEmpty((String)opts.get("q"))) {
                String q = (String)opts.get("q");
                b.addWhere("concat_ws(' ', username, firstname, lastname, email) LIKE ?", "%" + q + "%");
            }
        }
        ResultSet rs = b.queryResultSet();
        QueryResult<User> t = new QueryResult<User>();
        t.fill(User.class, rs, opts);
        return t;
    }

    public List<User> readByGroup(Integer userGroupId) throws SQLException, JTBException {
        String sql = "select u.* from base__user u join base__user_group_link ugl on (u.user_id = ugl.user_id) where ugl.user_group_id = ? ";
        List l = this.queryToList(User.class, sql, userGroupId);
        return l;
    }

    public boolean isAdmin(Integer userId) throws SQLException {
        if (userId == null) {
            return false;
        }
        BaseStringMap rec = this.connection.queryBsm("select * from base__user where user_id = ?", userId);
        if (rec == null) {
            return false;
        }
        if ("admin".equals(rec.getProperty("user_type"))) {
            return true;
        }
        if ("admin".equals(rec.getProperty("username"))) {
            return true;
        }
        return "1".equals(rec.getProperty("user_id"));
    }

    public String getUsername(Integer userId) throws SQLException {
        String n = (String)this.connection.queryValue("select username from base__user where user_id = ?", String.class, userId);
        if (n != null) {
            return n;
        }
        return "user-" + String.valueOf(userId);
    }

    public String getGroupName(Integer userGroupId) throws SQLException {
        String n = (String)this.connection.queryValue("select group_name from base__user_group where user_group_id = ?", String.class, userGroupId);
        if (n != null) {
            return n;
        }
        return "group-" + String.valueOf(userGroupId);
    }

    public int resetPasswordMail(String usernameOrEmail, String requestIp) throws SQLException, IOException, JTBException, MessagingException, RemoteApiException {
        int resetCount = 0;
        User u = this.readUser(usernameOrEmail);
        if (u != null) {
            this.resetPasswordMail(u, requestIp);
            ++resetCount;
        }
        List<User> users = this.readByEmail(usernameOrEmail);
        for (User u2 : users) {
            this.resetPasswordMail(u2, requestIp);
            ++resetCount;
        }
        return resetCount;
    }

    public ResetPassword resetPasswordMail(User u, String requestIp) throws SQLException, IOException, JTBException, MessagingException, RemoteApiException {
        if (!EmailValidator.getInstance().isValid(u.getEmail())) {
            throw new InvalidStateException("Invalid e-mailadres");
        }
        ResetPassword p = new ResetPassword();
        p.setUserId(u.getUserId());
        p.setUsername(u.getUsername());
        p.setSecurityString(CryptUtil.randomHash());
        p.setRequestIp(requestIp);
        this.connection.save("webmail__reset_password", "reset_password_id", p);
        EmailTemplate rp = this.emailTemplateService.readByCode("RESET_PASSWORD");
        if (rp == null) {
            throw new InvalidStateException("No reset e-mail template");
        }
        String resetLink = this.appConfig.buildAdminUrl("/resetpassword/?sec=" + p.getSecurityToken());
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("link", resetLink);
        EmailMessage m = rp.buildmessage(vars);
        m.addTo(u.getEmail(), u.getDisplayName());
        this.emailService.sendMail(m);
        return p;
    }

    public ResetPassword readPasswordResetBySec(String sec) throws SQLException, JTBException {
        if (sec == null || sec.indexOf(46) == -1) {
            return null;
        }
        Integer secid = NumberUtil.tryParseInt(sec.substring(0, sec.indexOf(46)));
        ResetPassword rp = (ResetPassword)this.queryToObject(ResetPassword.class, "select * from webmail__reset_password where reset_password_id = ?", secid);
        if (rp == null) {
            return null;
        }
        String str_secret = sec.substring(sec.indexOf(46) + 1);
        if (rp.getSecurityString() == null || !rp.getSecurityString().equals(str_secret)) {
            return null;
        }
        return rp;
    }

    public User doResetPassword(String securityString, String newPassword, String requestIp) throws SQLException, JTBException {
        ResetPassword rp = this.readPasswordResetBySec(securityString);
        if (rp == null) {
            throw new InvalidStateException("Invalid security token");
        }
        if (newPassword == null || newPassword.length() < 4) {
            throw new InvalidStateException("No valid password set");
        }
        String err = rp.getTokenError();
        if (err != null) {
            throw new InvalidStateException(err);
        }
        User u = this.readUser(rp.getUserId());
        this.connection.query("update webmail__reset_password set used_ip = ?, used = ? where reset_password_id = ?", requestIp, new Date(), rp.getResetPasswordId());
        u.setPasswordHashed(newPassword);
        this.connection.query("update base__user set password = ? where user_id = ?", u.getPassword(), u.getUserId());
        return u;
    }

    public void updateUserLog() {
        try {
            String sql1 = "select u.user_id from base__user u left join base__user_log ul on (u.user_id = ul.user_id) where ul.user_id is null";
            List<BaseStringMap> recs = this.connection.queryBsmList(sql1, new Object[0]);
            for (BaseStringMap rec : recs) {
                this.connection.query("insert into base__user_log (user_id, created) values (?, ?)", rec.getPropertyInt("user_id"), new Date());
            }
            String sql2 = "select ul.user_id from base__user_log ul left join base__user u on (ul.user_id = u.user_id) where u.user_id is null and ul.deleted is null";
            recs = this.connection.queryBsmList(sql2, new Object[0]);
            for (BaseStringMap rec : recs) {
                this.connection.query("update base__user_log set deleted = ? where user_id = ?", new Date(), rec.getPropertyInt("user_id"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public List<Integer> listAllIds() throws SQLException {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        List<BaseStringMap> recs = this.connection.queryBsmList("select user_id from base__user", new Object[0]);
        for (BaseStringMap rec : recs) {
            Integer id = rec.getPropertyInt("user_id");
            ids.add(id);
        }
        return ids;
    }
}

