/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.base.service;

import itx.erp.base.model.User;
import itx.erp.base.model.WebSession;
import itx.erp.base.service.ErpServiceBase;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import jtbcore.db.common.QueryBuilder;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.JTBException;
import jtbcore.util.CryptUtil;
import jtbcore.util.DateUtil;
import jtbcore.util.MapUtil;
import jtbcore.util.NumberUtil;

public class WebSessionService
extends ErpServiceBase {
    public static final int EXPIRY_1_WEEK = 604800;
    public static final int EXPIRY_1_MONTH = 2678400;

    public QueryResult<WebSession> searchSession(Map<String, Object> opts) throws SQLException {
        QueryBuilder b = new QueryBuilder(this.connection);
        b.setTable("base__web_session");
        b.addLeftJoin("base__user", "base__user.user_id = base__web_session.user_id");
        b.addSelectField("base__web_session", "web_session_id");
        b.addSelectField("base__web_session", "user_id");
        b.addSelectField("base__web_session", "expiry");
        b.addSelectField("base__web_session", "timestamp");
        b.addSelectField("base__user", "username");
        if (MapUtil.hasProperty(opts, "q")) {
            b.addWhere("username LIKE ?", "%" + opts.get("q").toString() + "%");
        }
        b.setRawOrderBy("timestamp desc");
        ResultSet rs = b.queryResultSet();
        QueryResult<WebSession> t = new QueryResult<WebSession>();
        t.fill(WebSession.class, rs, opts);
        return t;
    }

    public WebSession readSessionById(Integer webSessionId) throws SQLException, JTBException {
        WebSession s = (WebSession)super.queryToObject(WebSession.class, "select * from base__web_session where web_session_id = ?", webSessionId);
        return s;
    }

    public WebSession readSession(String code) throws SQLException, JTBException {
        if (code == null) {
            return null;
        }
        String[] tokens = code.split("\\.");
        if (tokens.length != 2) {
            return null;
        }
        Integer webSessionId = NumberUtil.tryParseInt(tokens[0]);
        String webSessionCode = tokens[1];
        WebSession s = (WebSession)super.queryToObject(WebSession.class, "select * from base__web_session where web_session_id = ? and session_code = ?", webSessionId, webSessionCode);
        return s;
    }

    public void cleanupSessions() throws IOException, SQLException {
        int t = DateUtil.unixTimestamp() - 2592000;
        this.connection.query("delete from base__web_session where timestamp < ?", t);
        int now = DateUtil.unixTimestamp();
        this.connection.query("delete from base__web_session where timestamp+expiry < ? and expiry <> -1", now);
    }

    public WebSession createSession(User user, Integer expiry) throws IOException, SQLException {
        return this.createSession(user, expiry, null);
    }

    public WebSession createSession(User user, Integer expiry, String note) throws IOException, SQLException {
        if (expiry == null) {
            expiry = 43200;
        }
        WebSession s = new WebSession();
        s.setUserId(user.getUserId());
        s.setExpiry(expiry);
        s.setSessionCode(CryptUtil.randomHash());
        s.setTimestamp(DateUtil.unixTimestamp());
        s.setNote(note);
        this.connection.save("base__web_session", "web_session_id", s.getBaseStringMap());
        return s;
    }

    public void updateTimestamp(WebSession ws) throws IOException, SQLException {
        if (ws == null || ws.getWebSessionId() == null) {
            return;
        }
        int now = DateUtil.unixTimestamp();
        this.connection.query("update base__web_session set timestamp = ? where web_session_id = ?", now, ws.getWebSessionId());
    }

    public void destroySession(Integer webSessionId) throws SQLException {
        if (webSessionId == null) {
            return;
        }
        this.connection.query("delete from base__web_session where web_session_id = ?", webSessionId);
    }

    public void destroySession(WebSession s) throws SQLException {
        if (s == null) {
            return;
        }
        this.connection.query("delete from base__web_session where web_session_id = ?", s.getWebSessionId());
    }

    public void destroySessionsForUser(Integer userId) throws SQLException {
        if (userId == null) {
            return;
        }
        this.connection.query("delete from base__web_session where user_id = ?", userId);
    }

    public WebSession getLocalAdminSession() throws IOException, SQLException, JTBException {
        this.cleanupSessions();
        WebSession ws = (WebSession)this.queryToObject(WebSession.class, "select * from base__web_session where user_id = 1 and session_type='local'", new Object[0]);
        if (ws == null) {
            ws = new WebSession();
            ws.setUserId(1);
            ws.setExpiry(-1);
            ws.setSessionCode(CryptUtil.randomHash());
            ws.setSessionType("local");
            ws.setTimestamp(DateUtil.unixTimestamp());
            this.connection.save("base__web_session", "web_session_id", ws.getBaseStringMap());
        }
        return ws;
    }
}

