/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.customer.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.base.model.TableSelectorResponse;
import itx.erp.customer.model.Address;
import itx.erp.customer.model.Customer;
import itx.erp.customer.model.Email;
import itx.erp.customer.model.Phone;
import itx.erp.customer.service.CustomerService;
import itx.erp.customer.validator.CustomerValidator;
import itx.erp.helper.ErpConfig;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.JTBException;
import jtbcore.model.KeyValueList;
import jtbcore.util.DateUtil;

public class CustomersController
extends BaseController {
    protected ErpConfig appConfig;
    protected CustomerService customerService;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public CustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    @Override
    public void handleRequest(WebRequest req) throws Exception {
        this.executeAction(req);
    }

    public void indexAction(WebRequest req) throws Exception {
        this.searchAction(req);
    }

    public void searchAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException, JTBException {
        Integer pageNo = req.getParamInt("pageNo", 0);
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("start", pageNo * this.appConfig.getLimit());
        opts.put("pageSize", this.appConfig.getLimit());
        opts.put("q", req.getParameter("q"));
        opts.put("customerId", req.getParameter("customerId"));
        opts.put("selectedCustomerId", req.getParameter("selectedCustomerId"));
        QueryResult<Customer> qrs = this.customerService.searchCustomers(opts);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("customers", qrs.getObjects());
        result.put("start", qrs.getStart());
        result.put("pageSize", qrs.getPageSize());
        result.put("rowCount", qrs.getRowCount());
        req.renderJson(result);
    }

    public void tableSearchAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException, JTBException {
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("start", 0);
        opts.put("pageSize", 5);
        opts.put("q", req.getParameter("q"));
        opts.put("selectedCustomerId", req.getParameter("value"));
        QueryResult<Customer> qrs = this.customerService.searchCustomers(opts);
        TableSelectorResponse r = new TableSelectorResponse();
        r.addHeader("customerTypeText", "Klant type");
        r.addHeader("customerName", "Klantnaam");
        r.addHeader("contactPerson", "Contactpersoon");
        r.addRecords(qrs.getObjects());
        req.renderJson(r);
    }

    public void viewAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Customer c = this.customerService.readCustomer(req.getParamInt("customerId"));
        HashMap<String, Object> r = new HashMap<String, Object>();
        if (c == null) {
            r.put("error", true);
            r.put("message", "Customer not found");
        } else {
            r.put("success", true);
            r.put("customer", c);
        }
        req.renderJson(r);
    }

    protected Customer buildCustomer(WebRequest req) throws SQLException, JTBException {
        KeyValueList kvlc = req.getKvl().getObject("customer");
        Integer customerId = kvlc.getValueInt("customerId");
        Customer c = customerId != null ? this.customerService.readCustomer(customerId) : new Customer();
        c.setCustomerType(kvlc.getValue("customerType"));
        c.setCustomerName(kvlc.getValueTrim("customerName"));
        c.setContactPerson(kvlc.getValueTrim("contactPerson"));
        Date birthDate = DateUtil.string2date(kvlc.getValue("birthDate"));
        c.setBirthDate(birthDate);
        c.setCocNumber(kvlc.getValueTrim("cocNumber"));
        c.setVatNumber(kvlc.getValueTrim("vatNumber"));
        c.setIban(kvlc.getValueTrim("iban"));
        c.setBic(kvlc.getValueTrim("bic"));
        c.setNote(kvlc.getValue("note"));
        c.setPhones(new ArrayList<Phone>());
        List<KeyValueList> l = kvlc.getList("phones");
        int x = 0;
        while (x < l.size()) {
            KeyValueList kvlp = l.get(x);
            Phone p = new Phone();
            p.setPhonenr(kvlp.getValueTrim("phonenr"));
            p.setDescription(kvlp.getValueTrim("description"));
            c.getPhones().add(p);
            ++x;
        }
        c.setEmails(new ArrayList<Email>());
        l = kvlc.getList("emails");
        x = 0;
        while (x < l.size()) {
            KeyValueList kvle = l.get(x);
            Email e = new Email();
            e.setEmailAddress(kvle.getValueTrim("emailAddress"));
            e.setDescription(kvle.getValueTrim("description"));
            c.getEmails().add(e);
            ++x;
        }
        c.setAddresses(new ArrayList<Address>());
        l = kvlc.getList("addresses");
        x = 0;
        while (x < l.size()) {
            KeyValueList kvla = l.get(x);
            Address a = new Address();
            a.setStreet(kvla.getValueTrim("street"));
            a.setStreetNo(kvla.getValueTrim("streetNo"));
            a.setZipcode(kvla.getValueTrim("zipcode"));
            a.setCity(kvla.getValueTrim("city"));
            a.setCountry(kvla.getValueTrim("country"));
            a.setNote(kvla.getValue("note"));
            c.getAddresses().add(a);
            ++x;
        }
        return c;
    }

    public void validateCustomerAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Customer c = this.buildCustomer(req);
        HashMap<String, Object> result = new HashMap<String, Object>();
        CustomerValidator v = new CustomerValidator();
        if (v.validate(c)) {
            result.put("success", true);
        } else {
            result.put("success", false);
            result.put("error", true);
            result.put("errors", v.getErrors());
        }
        req.renderJson(result);
    }

    public void saveAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Customer c = this.buildCustomer(req);
        HashMap<String, Object> result = new HashMap<String, Object>();
        CustomerValidator v = new CustomerValidator();
        if (v.validate(c)) {
            this.customerService.saveCustomer(c, req.getUserId());
            result.put("success", true);
            result.put("customer", c);
        } else {
            result.put("errors", v.getErrors());
            result.put("error", true);
        }
        req.renderJson(result);
    }

    public void deleteAction(WebRequest req) throws SQLException, JTBException, IOException {
        Integer customerId = req.getParamInt("customerId");
        this.customerService.deleteCustomer(customerId, req.getUserId());
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }
}

