/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.customer.service;

import itx.erp.base.model.Activity;
import itx.erp.base.service.ErpServiceBase;
import itx.erp.customer.model.Address;
import itx.erp.customer.model.Customer;
import itx.erp.customer.model.Email;
import itx.erp.customer.model.Phone;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import jtbcore.db.common.QueryBuilder;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.JTBException;
import jtbcore.model.BaseStringMap;
import jtbcore.util.MapUtil;
import jtbcore.util.NumberUtil;

public class CustomerService
extends ErpServiceBase {
    final String[] customerLogFields = new String[]{"customerType", "customerName", "contactPerson", "cocNumber", "vatNumber", "iban", "bic", "note", "emails.emailAddress", "emails.description", "phones.phonenr", "phones.description", "addresses.street", "addresses.streetNo", "addresses.zipcode", "addresses.city", "addresses.country", "addresses.note"};

    public QueryResult<Customer> searchCustomers(Map<String, Object> opts) throws SQLException, JTBException {
        QueryBuilder b = new QueryBuilder(this.connection);
        b.setTable("customer__customer");
        b.addSelectField("customer__customer", "customer_id");
        b.addSelectField("customer__customer", "customer_type");
        b.addSelectField("customer__customer", "customer_name");
        b.addSelectField("customer__customer", "contact_person");
        QueryBuilder.WhereClause wcDefault = new QueryBuilder.WhereClause(null);
        if (MapUtil.hasProperty(opts, "q")) {
            String q = opts.get("q").toString().trim();
            wcDefault.addWhere(" customer_name like ? or contact_person like ? ", "%" + q + "%", "%" + q + "%");
        }
        if (MapUtil.hasProperty(opts, "customerId")) {
            wcDefault.addWhere("customer__customer.customer_id = ?", opts.get("customerId"));
        }
        b.addWhere(wcDefault);
        b.setWhereJoin("OR");
        Integer selectedCustomerId = null;
        if (MapUtil.hasProperty(opts, "selectedCustomerId")) {
            selectedCustomerId = NumberUtil.tryParseInt(opts.get("selectedCustomerId").toString());
            if (!MapUtil.hasProperty(opts, "q") && wcDefault.hasClauses() && selectedCustomerId != null) {
                b.addWhere("customer__customer.customer_id = ?", selectedCustomerId);
            }
        }
        Object sqlOrderBy = "";
        if (selectedCustomerId != null) {
            sqlOrderBy = "customer__customer.customer_id = " + String.valueOf(selectedCustomerId) + " desc, ";
        }
        b.setRawOrderBy((String)sqlOrderBy + "lower(customer_name), lower(contact_person)");
        ResultSet rs = b.queryResultSet();
        QueryResult<Customer> qr = new QueryResult<Customer>();
        qr.fill(opts, Customer.class, rs);
        rs.close();
        int x = 0;
        while (x < qr.getObjects().size()) {
            Integer cid = qr.getObjects().get(x).getCustomerId();
            Customer c = this.readCustomer(cid);
            qr.getObjects().set(x, c);
            ++x;
        }
        return qr;
    }

    public Customer readCustomer(Integer customerId) throws SQLException, JTBException {
        Customer c = new Customer();
        BaseStringMap bsm = this.connection.queryBsm("select * from customer__customer where customer_id = ?", customerId);
        if (bsm == null) {
            return null;
        }
        c.setBaseStringMap(bsm);
        List phones = this.queryToList(Phone.class, "select * from customer__phone where customer_id = ? order by sort", customerId);
        List ads = this.queryToList(Address.class, "select * from customer__address where customer_id = ? order by sort", customerId);
        List mails = this.queryToList(Email.class, "select * from customer__email where customer_id = ? order by sort", customerId);
        c.setPhones(phones);
        c.setAddresses(ads);
        c.setEmails(mails);
        return c;
    }

    public String getCustomerName(Integer customerId) throws SQLException, JTBException {
        if (customerId == null) {
            return null;
        }
        Customer c = (Customer)this.queryToObject(Customer.class, "select * from customer__customer where customer_id = ?", customerId);
        if (c != null) {
            return c.getCustomerName();
        }
        return "customer-" + String.valueOf(customerId);
    }

    public void saveCustomer(Customer c, Integer loggedIn_userId) throws IOException, SQLException, JTBException {
        boolean isNew = c.getCustomerId() == null;
        Customer old = null;
        if (!isNew) {
            old = this.readCustomer(c.getCustomerId());
        }
        this.connection.save("customer__customer", "customer_id", c);
        this.connection.saveOTM("customer__phone", "customer_id", c.getCustomerId(), c.getPhones());
        this.connection.saveOTM("customer__address", "customer_id", c.getCustomerId(), c.getAddresses());
        this.connection.saveOTM("customer__email", "customer_id", c.getCustomerId(), c.getEmails());
        Activity a = new Activity();
        a.setUserId(loggedIn_userId);
        if (isNew) {
            a.setShortDescription("Customer created, " + c.getCustomerName());
            a.setCode("customer-created");
            a.logNew(c, this.customerLogFields);
        } else {
            a.setShortDescription("Customer Changed, " + c.getCustomerName());
            a.setCode("customer-updated");
            a.logChange(old, c, this.customerLogFields);
        }
        a.setRefObject(Customer.class.getName());
        a.setRefId(c.getCustomerId());
        a.setCustomerId(c.getCustomerId());
        this.saveActivity(a);
    }

    public void deleteCustomer(Integer customerId, Integer loggedIn_userId) throws SQLException, JTBException, IOException {
        Customer c = this.readCustomer(customerId);
        this.connection.query("delete from customer__address where customer_id = ?", c.getCustomerId());
        this.connection.query("delete from customer__phone where customer_id = ?", c.getCustomerId());
        this.connection.query("delete from customer__email where customer_id = ?", c.getCustomerId());
        this.connection.query("delete from customer__customer where customer_id = ?", c.getCustomerId());
        Activity a = new Activity();
        a.setUserId(loggedIn_userId);
        a.setShortDescription("Customer deleted, " + c.getCustomerName());
        a.setCode("customer-deleted");
        a.logDelete(c, this.customerLogFields);
        a.setRefObject(Customer.class.getName());
        a.setRefId(c.getCustomerId());
        a.setCustomerId(c.getCustomerId());
        this.saveActivity(a);
    }
}

