/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.factory;

import itx.erp.ErpObjectContainer;
import java.sql.SQLException;
import jtbcore.container.BeanFactory;
import jtbcore.db.mysql.MysqlConnection;
import jtbcore.db.sqlite.SqlLiteConnection;
import jtbcore.exception.ContainerException;
import jtbcore.exception.FileException;
import jtbcore.exception.InvalidStateException;
import jtbcore.setting.IniParser;

public class DbFactory
implements BeanFactory {
    @Override
    public Object createObject() throws InvalidStateException, SQLException, ClassNotFoundException, FileException, ContainerException {
        ErpObjectContainer oc = ErpObjectContainer.getInstance();
        if (ErpObjectContainer.HOSTED) {
            Class.forName("com.mysql.jdbc.Driver");
            MysqlConnection con = new MysqlConnection();
            con.setAutoReconnect(true);
            IniParser ip = new IniParser(oc.getDataDir() + "/settings.ini");
            ip.load();
            String username = ip.get("db", "username", "");
            String password = ip.get("db", "password", "");
            String dbname = ip.get("db", "name", "");
            String hostname = ip.get("db", "hostname", "127.0.0.1");
            con.setUsername(username);
            con.setPassword(password);
            con.setDatabaseName(dbname);
            con.setHost(hostname);
            con.connect();
            return con;
        }
        String datadir = oc.getDataDir();
        SqlLiteConnection con = new SqlLiteConnection();
        con.setPath(datadir + "/data.db");
        con.connect();
        return con;
    }
}

