/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.sales.conf.SalesSettings;
import itx.erp.sales.model.Article;
import itx.erp.sales.model.Vat;
import itx.erp.sales.rental.service.RentalService;
import itx.erp.sales.service.ArticleService;
import itx.erp.sales.service.SlotService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.JTBException;

public class SalesPlanController
extends BaseController {
    protected ArticleService articleService;
    protected SlotService slotService;
    protected RentalService rentalService;
    protected SalesSettings salesSettings;

    public ArticleService getArticleService() {
        return this.articleService;
    }

    public void setArticleService(ArticleService articleService) {
        this.articleService = articleService;
    }

    public SlotService getSlotService() {
        return this.slotService;
    }

    public void setSlotService(SlotService slotService) {
        this.slotService = slotService;
    }

    public RentalService getRentalService() {
        return this.rentalService;
    }

    public void setRentalService(RentalService rentalService) {
        this.rentalService = rentalService;
    }

    public SalesSettings getSalesSettings() {
        return this.salesSettings;
    }

    public void setSalesSettings(SalesSettings salesSettings) {
        this.salesSettings = salesSettings;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        this.executeAction(webRequest);
    }

    public void searchAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException, JTBException {
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("q", req.getParameter("q"));
        opts.put("rentable", true);
        QueryResult<Article> articles = this.articleService.searchArticle(opts);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("articles", articles.getObjects());
        result.put("success", true);
        req.renderJson(result);
    }

    public void pricesAction(WebRequest req) throws StreamWriteException, DatabindException, IOException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }

    public void configAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        List<Vat> vats = this.articleService.readVats();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("salesSettings", this.salesSettings);
        result.put("vats", vats);
        result.put("success", true);
        req.renderJson(result);
    }
}

