/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.model;

import java.text.DecimalFormat;
import java.util.Date;
import jtbcore.model.BaseStringMap;
import jtbcore.model.BaseStringMapObject;
import jtbcore.util.DateUtil;
import jtbcore.util.NumberUtil;

public class Vat
implements BaseStringMapObject {
    protected DecimalFormat df = new DecimalFormat("0.00");
    protected BaseStringMap bsm = new BaseStringMap();

    public Integer getVatId() {
        return this.bsm.getPropertyInt("vat_id");
    }

    public void setVatId(Integer p) {
        this.bsm.setProperty("vat_id", p);
    }

    public String getDescription() {
        return this.bsm.getProperty("description");
    }

    public void setDescription(String c) {
        this.bsm.setProperty("description", c);
    }

    public Double getPercentage() {
        return this.bsm.getPropertyDouble("percentage");
    }

    public void setPercentage(Double p) {
        this.bsm.setProperty("percentage", p);
    }

    public Boolean isVisible() {
        return this.bsm.getPropertyBool("visible");
    }

    public Boolean getVisible() {
        return this.bsm.getPropertyBool("visible");
    }

    public void setVisible(Boolean c) {
        this.bsm.setProperty("visible", c);
    }

    public Boolean isDefaultSelected() {
        return this.bsm.getPropertyBool("default_selected");
    }

    public Boolean getDefaultSelected() {
        return this.bsm.getPropertyBool("default_selected");
    }

    public void setDefaultSelected(Boolean c) {
        this.bsm.setProperty("default_selected", c);
    }

    public Integer getSort() {
        return this.bsm.getPropertyInt("sort");
    }

    public void setSort(Integer p) {
        this.bsm.setProperty("sort", p);
    }

    public Date getEdited() {
        return this.bsm.getPropertyDateTime("edited");
    }

    public void setEdited(Date d) {
        this.bsm.setProperty("edited", DateUtil.datetime2string(d));
    }

    public Date getCreated() {
        return this.bsm.getPropertyDateTime("created");
    }

    public void setCreated(Date d) {
        this.bsm.setProperty("created", DateUtil.datetime2string(d));
    }

    public Double calculateVat(Double price) {
        Double vatx100 = this.getPercentage() * 100.0;
        if (vatx100.intValue() == 0) {
            return 0.0;
        }
        Double p = price * this.getPercentage() / 100.0;
        String v = this.df.format(p);
        return Double.valueOf(v);
    }

    public Double addVat(Double price) {
        if (price == null) {
            return null;
        }
        Double vatx100 = this.getPercentage() * 100.0;
        if (vatx100.intValue() == 0) {
            return price;
        }
        Double p = price * (100.0 + this.getPercentage()) / 100.0;
        return NumberUtil.roundPrice(p);
    }

    public Double subtractVat(Double price) {
        if (price == null) {
            return null;
        }
        Double vatx100 = this.getPercentage() * 100.0;
        if (vatx100.intValue() == 0) {
            return price;
        }
        Double r = (100.0 + this.getPercentage()) / 100.0;
        Double p = price / r;
        return NumberUtil.roundPrice(p);
    }

    @Override
    public BaseStringMap getBaseStringMap() {
        return this.bsm;
    }

    @Override
    public void setBaseStringMap(BaseStringMap bsm) {
        this.bsm = bsm;
    }
}

