/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.webmail.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import itx.erp.webmail.model.EmailFile;
import itx.erp.webmail.model.EmailTo;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import jtbcore.model.BaseStringMap;
import jtbcore.model.BaseStringMapObject;
import org.apache.commons.validator.EmailValidator;

@JsonIgnoreProperties(value={"toAddresses"})
public class EmailMessage
implements BaseStringMapObject {
    protected BaseStringMap bsm;
    protected List<EmailTo> tos = new ArrayList<EmailTo>();
    protected List<EmailFile> files = new ArrayList<EmailFile>();
    protected String customerName;

    public EmailMessage() {
        this.bsm = new BaseStringMap();
        this.setStatus("draft");
    }

    public List<EmailTo> getTos() {
        return this.tos;
    }

    public void setTos(List<EmailTo> tos) {
        this.tos = tos;
    }

    public void addTo(String mail, String name) {
        EmailTo t = new EmailTo();
        t.setToType("to");
        t.setToName(name);
        t.setToEmail(mail);
        this.tos.add(t);
    }

    public List<EmailFile> getFiles() {
        return this.files;
    }

    public void setFiles(List<EmailFile> files) {
        this.files = files;
    }

    public void addFile(String filename, String path) {
        EmailFile f = new EmailFile();
        f.setFilename(filename);
        f.setPath(path);
        this.files.add(f);
    }

    public Address[] getToAddresses() throws UnsupportedEncodingException, AddressException {
        Address[] a = new Address[this.tos.size()];
        int x = 0;
        while (x < this.tos.size()) {
            a[x] = this.tos.get(x).hasToName() != false ? new InternetAddress(this.tos.get(x).getToEmail(), this.tos.get(x).getToName()) : new InternetAddress(this.tos.get(x).getToEmail());
            ++x;
        }
        return a;
    }

    public Integer getEmailMessageId() {
        return this.bsm.getPropertyInt("email_message_id");
    }

    public void setEmailMessageId(Integer i) {
        this.bsm.setProperty("email_message_id", i);
    }

    public Integer getUserId() {
        return this.bsm.getPropertyInt("user_id");
    }

    public void setUserId(Integer i) {
        this.bsm.setProperty("user_id", i);
    }

    public Integer getCustomerId() {
        return this.bsm.getPropertyInt("customer_id");
    }

    public void setCustomerId(Integer i) {
        this.bsm.setProperty("customer_id", i);
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public Integer getAttributes() {
        return this.bsm.getPropertyInt("attributes");
    }

    public void setAttributes(Integer i) {
        this.bsm.setProperty("attributes", i);
    }

    public Boolean getIncoming() {
        return this.bsm.getPropertyBool("incoming");
    }

    public void setIncoming(Boolean i) {
        this.bsm.setProperty("incoming", i);
    }

    public String getFromName() {
        return this.bsm.getProperty("from_name");
    }

    public void setFromName(String n) {
        this.bsm.setProperty("from_name", n);
    }

    public String getFromEmail() {
        return this.bsm.getProperty("from_email");
    }

    public void setFromEmail(String n) {
        this.bsm.setProperty("from_email", n);
    }

    public String getSubject() {
        return this.bsm.getProperty("subject");
    }

    public void setSubject(String n) {
        this.bsm.setProperty("subject", n);
    }

    public String getTextContent() {
        return this.bsm.getProperty("text_content");
    }

    public void setTextContent(String n) {
        this.bsm.setProperty("text_content", n);
    }

    public Integer getAttachmentCount() {
        return this.bsm.getPropertyInt("attachment_count");
    }

    public void setAttachmentCount(Integer i) {
        this.bsm.setProperty("attachment_count", i);
    }

    public String getStatus() {
        return this.bsm.getProperty("status");
    }

    public void setStatus(String n) {
        this.bsm.setProperty("status", n);
    }

    public Boolean getConfidential() {
        return this.bsm.getPropertyBool("confidential");
    }

    public void setConfidential(Boolean b) {
        this.bsm.setProperty("confidential", b != null && b != false ? "1" : "0");
    }

    public Date getSent() {
        return this.bsm.getPropertyDate("sent");
    }

    public void setSent(Date n) {
        this.bsm.setProperty("sent", n);
    }

    public Date getDeleted() {
        return this.bsm.getPropertyDate("deleted");
    }

    public void setDeleted(Date n) {
        this.bsm.setProperty("deleted", n);
    }

    public Date getEdited() {
        return this.bsm.getPropertyDate("edited");
    }

    public void setEdited(Date n) {
        this.bsm.setProperty("edited", n);
    }

    public Date getCreated() {
        return this.bsm.getPropertyDate("created");
    }

    public void setCreated(Date n) {
        this.bsm.setProperty("created", n);
    }

    public boolean hasValidTo() {
        for (EmailTo et : this.getTos()) {
            if (!EmailValidator.getInstance().isValid(et.getToEmail())) continue;
            return true;
        }
        return false;
    }

    @Override
    public BaseStringMap getBaseStringMap() {
        return this.bsm;
    }

    @Override
    public void setBaseStringMap(BaseStringMap bsm) {
        this.bsm = bsm;
    }
}

