/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.conf;

import itx.erp.ErpObjectContainer;
import itx.erp.base.service.ActivityService;
import itx.erp.helper.ErpConfig;
import java.io.IOException;
import java.sql.SQLException;
import jtbcore.exception.ContainerException;
import jtbcore.exception.InvalidArgument;

public class RtobConf {
    protected static RtobConf instance = null;
    protected ErpConfig appConfig;

    public RtobConf() {
        try {
            this.appConfig = ErpObjectContainer.getInstance().getAppConfig();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setApiActive(boolean b) throws SQLException, IOException {
        this.appConfig.setSetting("r2b_active", b ? "1" : "0");
    }

    public boolean isActive() throws SQLException {
        int i = this.appConfig.getSettingInt("r2b_active", 0);
        return i == 1;
    }

    public String getRelayName() throws SQLException {
        return this.appConfig.getSetting("r2b_relayName", "");
    }

    public String getRelayAlias() throws SQLException {
        return this.appConfig.getSetting("r2b_relayAlias", "");
    }

    public void setRelayAlias(String p) throws IOException, SQLException {
        this.appConfig.setSetting("r2b_relayAlias", p);
    }

    public String getPassword() throws SQLException {
        return this.appConfig.getSetting("r2b_password", "");
    }

    public void setPassword(String p) throws SQLException, IOException {
        this.appConfig.setSetting("r2b_password", p);
    }

    public String getAuthenticationMethod() throws SQLException {
        return this.appConfig.getSetting("r2b_authenticationMethod", "login_request");
    }

    public void setAuthenticationMethod(String m) throws SQLException, InvalidArgument, IOException {
        if (!"login_request".equals(m) && !"login".equals(m)) {
            throw new InvalidArgument("Invalid method: " + m);
        }
        this.appConfig.setSetting("r2b_authenticationMethod", m);
    }

    public String getAppUrl() throws SQLException {
        if (ErpObjectContainer.HOSTED) {
            return "https://www.report2base.nl/app/";
        }
        String s = this.appConfig.getSetting("r2b_appUrl");
        if (s == null || s.trim().length() == 0) {
            return "https://www.report2base.nl/app/";
        }
        return s;
    }

    public void setAppUrl(String p) throws IOException, SQLException {
        this.appConfig.setSetting("r2b_appUrl", p);
    }

    public String getAdminUrl() throws SQLException {
        if (ErpObjectContainer.HOSTED) {
            return "https://admin.report2base.nl/" + this.getRelayName() + "/";
        }
        String s = this.appConfig.getSetting("r2b_adminUrl");
        if (s == null || s.trim().length() == 0) {
            return "http://localhost:" + String.valueOf(this.appConfig.getServerPort()) + "/";
        }
        return s;
    }

    public void setAdminUrl(String p) throws IOException, SQLException {
        this.appConfig.setSetting("r2b_adminUrl", p);
    }

    public String getHoursDefaultTimingType() throws SQLException {
        String t = this.appConfig.getSetting("hoursDefaultTimingType");
        if (!"from_to".equals(t) && !"duration".equals(t)) {
            return "from_to";
        }
        return t;
    }

    public void setHoursDefaultTimingType(String t, Integer reqUserId) throws SQLException, IOException, InvalidArgument, ContainerException {
        String prev = this.getHoursDefaultTimingType();
        if (t.equals(prev)) {
            return;
        }
        if (!"from_to".equals(t) && !"duration".equals(t)) {
            throw new InvalidArgument("Invalid timing type");
        }
        ActivityService aservice = ErpObjectContainer.getInstance().getActivityService();
        aservice.createActivityRef(reqUserId, "RtobSettings.hoursDefaultTimingType", null, "hours-default-timing", "Default timing type changed: " + prev + " => " + t, null);
        this.appConfig.setSetting("hoursDefaultTimingType", t);
    }

    public static synchronized RtobConf getInstance() {
        if (instance == null) {
            instance = new RtobConf();
        }
        return instance;
    }
}

