/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.r2b.model.AppAuthRequest;
import itx.r2b.service.RelayService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import jtbcore.exception.JTBException;

public class AppAuthRequestController
extends BaseController {
    protected RelayService relayService;

    public RelayService getRelayService() {
        return this.relayService;
    }

    public void setRelayService(RelayService relayService) {
        this.relayService = relayService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        super.executeAction(webRequest);
    }

    public void listAuthsAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer lastReqId = req.getParamInt("lastAppAuthRequestId");
        List<AppAuthRequest> authreqs = this.relayService.readLastAuths(100, lastReqId);
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("success", true);
        r.put("requests", authreqs);
        req.renderJson(r);
    }

    public void truncateRequestsAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException {
        this.relayService.truncateRequests();
        HashMap<String, Boolean> r = new HashMap<String, Boolean>();
        r.put("success", true);
        req.renderJson(r);
    }

    public void acceptRequestAction(WebRequest req) throws SQLException, IOException, JTBException {
        this.getRelayService().acceptRequest(req.getParamInt("id"), req.getUserId(), req.getParamInt("selectedUserId"));
        HashMap<String, Boolean> r = new HashMap<String, Boolean>();
        r.put("success", true);
        req.renderJson(r);
    }

    public void rejectRequestAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException {
        this.getRelayService().rejectRequest(req.getParamInt("id"), req.getUserId());
        HashMap<String, Boolean> r = new HashMap<String, Boolean>();
        r.put("success", true);
        req.renderJson(r);
    }
}

