/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.controller;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.r2b.RtobObjectContainer;
import itx.r2b.StartRtob;
import itx.r2b.conf.RtobConf;
import itx.r2b.relay.RelayHandler;
import itx.r2b.service.RelayService;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.HashMap;
import jtbcore.exception.ContainerException;
import jtbcore.exception.InvalidArgument;
import jtbcore.util.PasswordUtil;
import jtbcore.util.RequestUrl;

public class RelaySettingsController
extends BaseController {
    protected RelayService relayService;
    protected RtobConf rtobConf = RtobConf.getInstance();

    public RelayService getRelayService() {
        return this.relayService;
    }

    public void setRelayService(RelayService relayService) {
        this.relayService = relayService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        super.executeAction(webRequest);
    }

    protected boolean relayRoutingEditable() throws ContainerException {
        RtobObjectContainer oc = RtobObjectContainer.getInstance();
        if (oc.isHosted()) {
            return false;
        }
        return !oc.getAppConfig().isDesktopMode();
    }

    public void settingsAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, URISyntaxException, ContainerException {
        String locationUrl = null;
        try {
            RequestUrl ru = new RequestUrl("https://www.report2base.nl/route/" + this.rtobConf.getRelayName());
            ru.post();
            String jsondata = ru.getResponseData();
            ObjectMapper om = new ObjectMapper();
            JsonNode jn = om.readTree(jsondata);
            if (jn.has("success") && jn.has("url")) {
                locationUrl = jn.get("url").asText();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("success", true);
        r.put("rtobApiActive", this.rtobConf.isActive());
        r.put("rtobRelayName", this.rtobConf.getRelayName());
        r.put("rtobRelayAlias", this.rtobConf.getRelayAlias());
        r.put("rtobPassword", this.rtobConf.getPassword());
        r.put("rtobAuthenticationMethod", this.rtobConf.getAuthenticationMethod());
        r.put("rtobAppUrl", this.rtobConf.getAppUrl());
        r.put("rtobAdminUrl", this.rtobConf.getAdminUrl());
        r.put("relayRoutingEditable", this.relayRoutingEditable());
        r.put("locationUrl", locationUrl);
        req.renderJson(r);
    }

    public void saveSettingsAction(WebRequest req) throws SQLException, IOException, URISyntaxException, InvalidArgument, ContainerException {
        if (this.relayRoutingEditable() && !req.getParamBool("apiActive").booleanValue()) {
            this.rtobConf.setApiActive(false);
            StartRtob.stopRelay();
            HashMap<String, Boolean> r = new HashMap<String, Boolean>();
            r.put("success", true);
            req.renderJson(r);
            return;
        }
        if (RelayHandler.relayEnabled()) {
            StartRtob.startRelay();
        } else {
            StartRtob.stopRelay();
        }
        this.rtobConf.setApiActive(true);
        this.rtobConf.setAuthenticationMethod(req.getParameter("authenticationMethod"));
        if (req.hasParameter("rtobAppUrl")) {
            this.rtobConf.setAppUrl(req.getParameter("rtobAppUrl"));
        }
        RequestUrl ru = new RequestUrl("https://www.report2base.nl/api/updatesettings");
        ru.setRequestParam("relayName", this.rtobConf.getRelayName());
        ru.setRequestParam("password", this.rtobConf.getPassword());
        ru.setRequestParam("relayAlias", req.getParameter("relayAlias"));
        ru.setRequestParam("newPassword", req.getParameter("password"));
        if (this.relayRoutingEditable()) {
            ru.setRequestParam("relayLocation", req.getParameter("relayLocation"));
        }
        ru.post();
        String jsondata = ru.getResponseData();
        ObjectMapper om = new ObjectMapper();
        JsonNode jnroot = om.readTree(jsondata);
        if (jnroot.has("success") && jnroot.get("success").asBoolean()) {
            if (jnroot.has("relayAlias")) {
                this.rtobConf.setRelayAlias(jnroot.get("relayAlias").asText());
            }
            if (req.hasParameter("password") && !req.getParameter("password").equals(this.rtobConf.getPassword())) {
                this.rtobConf.setPassword(req.getParameter("password"));
            }
            HashMap<String, Boolean> r = new HashMap<String, Boolean>();
            r.put("success", true);
            req.renderJson(r);
            return;
        }
        RequestUrl ru2 = new RequestUrl("https://www.report2base.nl/api/checkww");
        ru2.setRequestParam("relayAlias", req.getParameter("relayAlias"));
        ru2.setRequestParam("password", req.getParameter("password"));
        ru2.post();
        String jsondata2 = ru2.getResponseData();
        ObjectMapper om2 = new ObjectMapper();
        JsonNode jnroot2 = om2.readTree(jsondata2);
        Boolean b = jnroot2.has("success") && jnroot2.get("success").asBoolean();
        if (b.booleanValue()) {
            this.rtobConf.setRelayAlias(req.getParameter("relayAlias"));
            this.rtobConf.setPassword(req.getParameter("password"));
        }
        StartRtob.startRelay();
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("error", true);
        if (jnroot.has("error")) {
            r.put("message", jnroot.get("message").asText());
        } else {
            r.put("message", "Onbekende fout opgetreden");
        }
        req.renderJson(r);
    }

    public void relayConfiguredAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException {
        HashMap<String, Boolean> r = new HashMap<String, Boolean>();
        r.put("success", true);
        r.put("configured", this.getRelayService().isConfigured());
        req.renderJson(r);
    }

    public void registerAppAction(WebRequest req) throws SQLException, IOException, URISyntaxException {
        String relayAlias = req.getParameter("relayAlias");
        if (relayAlias == null) {
            relayAlias = "";
        }
        if ("skip".equals(relayAlias = relayAlias.trim())) {
            this.getRelayService().markConfigured();
            HashMap<String, Boolean> r = new HashMap<String, Boolean>();
            r.put("success", true);
            req.renderJson(r);
            return;
        }
        String password = PasswordUtil.generatePassword();
        RequestUrl ru = new RequestUrl("https://www.report2base.nl/api/register");
        ru.setRequestParam("relayAlias", relayAlias);
        ru.setRequestParam("password", password);
        ru.post();
        String jsondata = ru.getResponseData();
        ObjectMapper om = new ObjectMapper();
        JsonNode jnroot = om.readTree(jsondata);
        Boolean b = jnroot.has("success") ? jnroot.get("success").asBoolean() : false;
        if (b.booleanValue()) {
            this.getRelayService().getAppConfig().setSetting("r2b_active", "1");
            this.getRelayService().getAppConfig().setSetting("r2b_relayName", jnroot.get("relayName").asText());
            this.getRelayService().getAppConfig().setSetting("r2b_relayAlias", jnroot.get("relayAlias").asText());
            this.getRelayService().getAppConfig().setSetting("r2b_password", password);
            this.getRelayService().markConfigured();
            HashMap<String, Boolean> r = new HashMap<String, Boolean>();
            r.put("success", true);
            req.renderJson(r);
            return;
        }
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("error", true);
        String errorCode = jnroot.get("error_code").asText();
        r.put("error_code", errorCode);
        if ("invalid_name".equals(errorCode)) {
            r.put("message", "Ongeldige naam. Alleen letters + cijfers toegestaan");
        } else if ("already_used".equals(errorCode)) {
            r.put("message", "Naam reeds in gebruik");
        } else if ("complexity_password".equals(errorCode)) {
            r.put("message", "Wachtwoord te eenvoudig");
        } else if ("internal_error".equals(errorCode)) {
            r.put("message", "Interne fout opgetreden. Probeer opnieuw");
        } else {
            r.put("message", jnroot.get("message").asText());
        }
        req.renderJson(r);
    }

    public void authAppAction(WebRequest req) throws SQLException, IOException, URISyntaxException {
        String relayAlias = req.getParameter("relayAlias");
        if (relayAlias == null) {
            relayAlias = "";
        }
        relayAlias = relayAlias.trim();
        String password = req.getParameter("password");
        RequestUrl ru = new RequestUrl("https://www.report2base.nl/api/checkww");
        ru.setRequestParam("relayAlias", relayAlias);
        ru.setRequestParam("password", password);
        ru.post();
        String jsondata = ru.getResponseData();
        ObjectMapper om = new ObjectMapper();
        JsonNode jnroot = om.readTree(jsondata);
        Boolean b = jnroot.has("success") && jnroot.get("success").asBoolean();
        if (b.booleanValue()) {
            this.getRelayService().getAppConfig().setSetting("r2b_active", "1");
            this.getRelayService().getAppConfig().setSetting("r2b_relayName", jnroot.get("relayName").asText());
            this.getRelayService().getAppConfig().setSetting("r2b_relayAlias", jnroot.get("relayAlias").asText());
            this.getRelayService().getAppConfig().setSetting("r2b_password", password);
            this.getRelayService().markConfigured();
            HashMap<String, Boolean> r = new HashMap<String, Boolean>();
            r.put("success", true);
            req.renderJson(r);
            return;
        }
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("error", true);
        r.put("message", jnroot.get("message").asText());
        req.renderJson(r);
    }
}

