/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.controller.app;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.RelayBaseController;
import itx.core.web.WebRequest;
import itx.erp.base.model.User;
import itx.erp.base.model.WebSession;
import itx.erp.base.service.UserService;
import itx.erp.base.service.WebSessionService;
import itx.erp.helper.ErpConfig;
import itx.r2b.conf.RtobConf;
import itx.r2b.controller.websocket.WebsocketClientHolder;
import itx.r2b.model.AppAuthRequest;
import itx.r2b.service.RelayService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import jtbcore.exception.ContainerException;
import jtbcore.exception.InvalidStateException;
import jtbcore.exception.JTBException;

public class RtobAuthController
extends RelayBaseController {
    protected ErpConfig appConfig;
    protected UserService userService;
    protected WebSessionService webSessionService;
    protected RelayService relayService;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public WebSessionService getWebSessionService() {
        return this.webSessionService;
    }

    public void setWebSessionService(WebSessionService webSessionService) {
        this.webSessionService = webSessionService;
    }

    public RelayService getRelayService() {
        return this.relayService;
    }

    public void setRelayService(RelayService relayService) {
        this.relayService = relayService;
    }

    @Override
    public boolean checkAuthentication(WebRequest req) {
        return true;
    }

    public void authenticateAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException, ContainerException {
        String username = req.getParameter("username");
        String password = req.getParameter("password");
        User u = this.getUserService().readUser(username);
        if (u == null) {
            req.renderJsonErrorMessage("User not found");
            return;
        }
        if (!u.checkPassword(password)) {
            req.renderJsonErrorMessage("Invalid password");
            return;
        }
        WebSession ws = this.webSessionService.createSession(u, 604800, "r2b app");
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("success", true);
        r.put("jtbauth", ws.getCookieValue());
        req.renderJson(r);
    }

    public void requestAccessAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, InvalidStateException {
        if (!"login_request".equals(RtobConf.getInstance().getAuthenticationMethod())) {
            throw new InvalidStateException("Request access not enabled");
        }
        String a = req.getParameter("requestAuthName");
        if (a == null || a.trim().length() == 0) {
            req.renderJsonErrorMessage("No name entered");
            return;
        }
        AppAuthRequest ar = new AppAuthRequest();
        ar.setInputName(a);
        ar.setIp(req.getRemoteIp());
        ar.setUserAgent(req.getRequest().getHeader("User-Agent"));
        this.getRelayService().createAuthRequest(ar);
        WebsocketClientHolder.sendMessage("app_auth_request_updated");
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("success", true);
        r.put("app_auth_request_id", ar.getAppAuthRequestId());
        r.put("app_auth_request_uid", ar.getCookieValue());
        req.renderJson(r);
    }

    public void checkRequestAccessAction(WebRequest req) throws InvalidStateException, SQLException, StreamWriteException, DatabindException, IOException {
        if (!"login_request".equals(RtobConf.getInstance().getAuthenticationMethod())) {
            throw new InvalidStateException("Request access not enabled");
        }
        HashMap<String, Object> r = new HashMap<String, Object>();
        String uid = req.getParameter("app_auth_request_uid");
        try {
            WebSession ws = this.getRelayService().doAppAuthRequest(uid);
            r.put("success", true);
            if (ws == null) {
                r.put("message", "Pending...");
                WebsocketClientHolder.sendMessage("app_auth_request_updated");
            } else {
                r.put("message", "OK");
                r.put("jtbauth", ws.getCookieValue());
                r.put("authenticated", true);
            }
        }
        catch (Exception ex) {
            r.put("error", true);
            r.put("message", ex.getMessage());
        }
        req.renderJson(r);
    }

    public void sessionInfoAction(WebRequest req) throws ContainerException, SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        String jtbauth = req.getParameter("jtbauth");
        WebSession s = this.webSessionService.readSession(jtbauth);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (s != null) {
            result.put("success", true);
            result.put("username", s.getUsername());
        } else {
            result.put("success", false);
            result.put("error", true);
        }
        req.renderJson(result);
    }

    public void destroySessionAction(WebRequest req) throws ContainerException, SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        String jtbauth = req.getParameter("jtbauth");
        WebSession s = this.webSessionService.readSession(jtbauth);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (s != null) {
            this.webSessionService.destroySession(s);
            result.put("success", true);
        } else {
            result.put("success", false);
            result.put("error", true);
            result.put("message", "Invalid jtbauth-session");
        }
        req.renderJson(result);
    }
}

