/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.controller.app;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.RelayBaseController;
import itx.core.web.WebRequest;
import itx.erp.base.model.WebSession;
import itx.erp.customer.model.Customer;
import itx.erp.customer.service.CustomerService;
import itx.erp.helper.ErpConfig;
import itx.r2b.RtobObjectContainer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import jtbcore.db.common.QueryResult;
import jtbcore.db.common.SqlConnection;
import jtbcore.exception.JTBException;

public class RtobCustomersController
extends RelayBaseController {
    protected SqlConnection connection;
    protected ErpConfig appConfig;
    protected CustomerService customerService;

    public SqlConnection getConnection() {
        return this.connection;
    }

    public void setConnection(SqlConnection connection) {
        this.connection = connection;
    }

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public CustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    @Override
    public boolean checkAuthentication(WebRequest req) throws Exception {
        String jtbauth = req.getParameter("jtbauth");
        WebSession s = RtobObjectContainer.getInstance().getWebSessionService().readSession(jtbauth);
        if (s != null) {
            req.setWebSession(s);
            return true;
        }
        return false;
    }

    public void searchAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        Integer start = req.getParamInt("start", 0);
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("start", start);
        opts.put("pageSize", this.listLimit);
        opts.put("q", req.getParameter("q"));
        QueryResult<Customer> qrs = this.customerService.searchCustomers(opts);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("customers", qrs.getObjects());
        result.put("start", qrs.getStart());
        result.put("pageSize", qrs.getPageSize());
        result.put("rowCount", qrs.getRowCount());
        req.renderJson(result);
    }

    public void viewAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Customer c = this.customerService.readCustomer(req.getParamInt("customerId"));
        HashMap<String, Object> r = new HashMap<String, Object>();
        if (c == null) {
            r.put("error", true);
            r.put("message", "Customer not found");
        } else {
            r.put("success", true);
            r.put("customer", c);
            Integer workOrderCount = (Integer)this.connection.queryValue("select count(*) from rtob__work_order where customer_id = ?", Integer.class, c.getCustomerId());
            Integer workHourCount = (Integer)this.connection.queryValue("select count(*) from rtob__work_hour where customer_id = ?", Integer.class, c.getCustomerId());
            Integer workFeedbackCount = (Integer)this.connection.queryValue("select count(*) from rtob__work_feedback where customer_id = ?", Integer.class, c.getCustomerId());
            r.put("workOrderCount", workOrderCount);
            r.put("workHourCount", workHourCount);
            r.put("workFeedbackCount", workFeedbackCount);
        }
        req.renderJson(r);
    }
}

