/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.controller.app;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.RelayBaseController;
import itx.core.web.WebRequest;
import itx.erp.base.model.WebSession;
import itx.erp.helper.ErpConfig;
import itx.r2b.RtobObjectContainer;
import itx.r2b.model.WorkFeedback;
import itx.r2b.service.WorkFeedbackService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.JTBException;

public class RtobFeedbackController
extends RelayBaseController {
    protected ErpConfig appConfig;
    protected WorkFeedbackService workFeedbackService;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public WorkFeedbackService getWorkFeedbackService() {
        return this.workFeedbackService;
    }

    public void setWorkFeedbackService(WorkFeedbackService workFeedbackService) {
        this.workFeedbackService = workFeedbackService;
    }

    @Override
    public boolean checkAuthentication(WebRequest req) throws Exception {
        String jtbauth = req.getParameter("jtbauth");
        WebSession s = RtobObjectContainer.getInstance().getWebSessionService().readSession(jtbauth);
        if (s != null) {
            req.setWebSession(s);
            return true;
        }
        return false;
    }

    public void searchAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        Integer pageNo = req.getParamInt("pageNo", 0);
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("start", pageNo * this.listLimit);
        opts.put("pageSize", this.listLimit);
        opts.put("q", req.getParameter("q"));
        if (req.hasParameter("cid")) {
            opts.put("cid", req.getParamInt("cid"));
        }
        if (req.hasParameter("uid")) {
            opts.put("uid", req.getParamIntStripPrefix("uid"));
        }
        if (req.hasParameter("sd")) {
            opts.put("startDate", req.getParamDate("startDate"));
        }
        if (req.hasParameter("ed")) {
            opts.put("endDate", req.getParamDate("endDate"));
        }
        if (req.hasParameter("status")) {
            opts.put("status", req.getParameter("status"));
        }
        QueryResult<WorkFeedback> qrs = this.workFeedbackService.searchFeedback(opts, req.getUserId());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("feedbackList", qrs.getObjects());
        result.put("start", qrs.getStart());
        result.put("pageSize", qrs.getPageSize());
        result.put("rowCount", qrs.getRowCount());
        req.renderJson(result);
    }

    public void viewAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        WorkFeedback f = this.workFeedbackService.readFeedback(req.getParamInt("feedbackId"), req.getUserId());
        HashMap<String, Object> r = new HashMap<String, Object>();
        if (f == null) {
            r.put("error", true);
            r.put("message", "Feedback not found");
        } else {
            r.put("success", true);
            r.put("feedback", f);
        }
        req.renderJson(r);
    }
}

