/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.controller.app;

import itx.core.web.RelayBaseController;
import itx.core.web.WebRequest;
import itx.erp.base.model.DbFile;
import itx.erp.base.model.WebSession;
import itx.erp.base.service.FileService;
import itx.erp.base.service.UserService;
import itx.r2b.RtobObjectContainer;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Date;
import jtbcore.exception.JTBException;
import jtbcore.util.FileUtil;

public class RtobFileController
extends RelayBaseController {
    protected FileService fileService;
    protected UserService userService;

    public FileService getFileService() {
        return this.fileService;
    }

    public void setFileService(FileService fileService) {
        this.fileService = fileService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Override
    public boolean checkAuthentication(WebRequest req) throws Exception {
        String jtbauth = req.getParameter("jtbauth");
        WebSession s = RtobObjectContainer.getInstance().getWebSessionService().readSession(jtbauth);
        if (s != null) {
            req.setWebSession(s);
            return true;
        }
        return false;
    }

    public void downloadFileAction(WebRequest req) throws SQLException, JTBException, IOException {
        Integer id = req.getParamInt("dbFileId");
        DbFile f = this.fileService.readFile(id);
        String p = RtobObjectContainer.getInstance().getFilesDir() + "/" + f.getPath();
        File file = new File(p);
        String attinline = req.getParamBool("inline") != false ? "inline" : "attachment";
        long expirySeconds = 2592000L;
        req.getResponse().setHeader("Cache-Control", "private, max-age=" + expirySeconds);
        Date d = new Date();
        d.setTime(d.getTime() + expirySeconds * 1000L);
        req.getResponse().setHeader("Expires", d.toGMTString());
        req.getResponse().setHeader("Content-Disposition", attinline + "; filename=\"" + f.getOriginalFilename() + "\"");
        FileUtil.file2outputstream(file, (OutputStream)req.getResponse().getOutputStream());
    }
}

