/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.controller.app;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.RelayBaseController;
import itx.core.web.WebRequest;
import itx.erp.base.model.WebSession;
import itx.erp.helper.ErpConfig;
import itx.r2b.RtobObjectContainer;
import itx.r2b.conf.RtobConf;
import itx.r2b.model.WorkHour;
import itx.r2b.service.WorkHourService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.JTBException;

public class RtobHourController
extends RelayBaseController {
    protected ErpConfig appConfig;
    protected WorkHourService workHourService;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public WorkHourService getWorkHourService() {
        return this.workHourService;
    }

    public void setWorkHourService(WorkHourService workHourService) {
        this.workHourService = workHourService;
    }

    @Override
    public boolean checkAuthentication(WebRequest req) throws Exception {
        String jtbauth = req.getParameter("jtbauth");
        WebSession s = RtobObjectContainer.getInstance().getWebSessionService().readSession(jtbauth);
        if (s != null) {
            req.setWebSession(s);
            return true;
        }
        return false;
    }

    public void searchAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException {
        Integer pageNo = req.getParamInt("pageNo", 0);
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("start", pageNo * this.listLimit);
        opts.put("pageSize", this.listLimit);
        opts.put("q", req.getParameter("q"));
        if (req.hasParameter("cid")) {
            opts.put("cid", req.getParamInt("cid"));
        }
        if (req.hasParameter("uid")) {
            opts.put("uid", req.getParamIntStripPrefix("uid"));
        }
        if (req.hasParameter("sd")) {
            opts.put("startDate", req.getParamDate("startDate"));
        }
        if (req.hasParameter("ed")) {
            opts.put("endDate", req.getParamDate("endDate"));
        }
        if (req.hasParameter("reportStatus")) {
            opts.put("reportStatus", req.getParameter("reportStatus"));
        }
        QueryResult<WorkHour> qrs = this.workHourService.searchHours(opts, req.getUserId());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("hours", qrs.getObjects());
        result.put("start", qrs.getStart());
        result.put("pageSize", qrs.getPageSize());
        result.put("rowCount", qrs.getRowCount());
        req.renderJson(result);
    }

    public void viewAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        WorkHour h = this.workHourService.readHour(req.getParamInt("hourId"), req.getUserId());
        HashMap<String, Object> r = new HashMap<String, Object>();
        if (h == null) {
            r.put("error", true);
            r.put("message", "Hour not found");
        } else {
            r.put("success", true);
            r.put("hour", h);
        }
        req.renderJson(r);
    }

    public void defaultsAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        WorkHour h = new WorkHour();
        h.setTimingType(RtobConf.getInstance().getHoursDefaultTimingType());
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("success", true);
        r.put("hour", h);
        req.renderJson(r);
    }
}

