/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.controller.app;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.RelayBaseController;
import itx.core.web.WebRequest;
import itx.erp.base.model.User;
import itx.erp.base.model.WebSession;
import itx.erp.base.service.UserService;
import itx.erp.helper.ErpConfig;
import itx.r2b.RtobObjectContainer;
import itx.r2b.conf.RtobConf;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import jtbcore.exception.ContainerException;
import jtbcore.exception.JTBException;

public class RtobInfoController
extends RelayBaseController {
    protected RtobObjectContainer objectContainer;
    protected ErpConfig appConfig;
    protected UserService userService;

    public RtobObjectContainer getObjectContainer() {
        return this.objectContainer;
    }

    public void setObjectContainer(RtobObjectContainer objectContainer) {
        this.objectContainer = objectContainer;
    }

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Override
    public boolean checkAuthentication(WebRequest req) throws ContainerException, SQLException, JTBException {
        String jtbauth = req.getParameter("jtbauth");
        WebSession s = RtobObjectContainer.getInstance().getWebSessionService().readSession(jtbauth);
        if (s != null) {
            req.setWebSession(s);
        }
        return true;
    }

    public void indexAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException {
        RtobConf c = RtobConf.getInstance();
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("appVersion", this.objectContainer.getProperty("rtobAppVersion"));
        r.put("authenticationMethod", c.getAuthenticationMethod());
        r.put("service", ErpConfig.runsAsWinService());
        r.put("hosted", this.objectContainer.isHosted());
        r.put("companyName", this.appConfig.getSetting("companyName"));
        r.put("relayAlias", RtobConf.getInstance().getRelayAlias());
        r.put("relayName", RtobConf.getInstance().getRelayName());
        r.put("success", true);
        r.put("user", null);
        if (req.getWebSession() != null && req.getWebSession().getUserId() != null) {
            User user = this.userService.readUser(req.getWebSession().getUserId());
            HashMap<String, Object> map_user = new HashMap<String, Object>();
            map_user.put("userId", user.getUserId());
            map_user.put("username", user.getUsername());
            map_user.put("userType", user.getUserType());
            map_user.put("admin", user.isAdmin());
            map_user.put("permissions", user.getPermissions());
            map_user.put("email", user.getEmail());
            r.put("user", map_user);
        }
        req.renderJson(r);
    }

    public void sleeptestAction(WebRequest req) throws InterruptedException, StreamWriteException, DatabindException, IOException {
        Thread.sleep(5000L);
        HashMap<String, Boolean> r = new HashMap<String, Boolean>();
        r.put("success", true);
        req.renderJson(r);
    }
}

