/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.controller.app;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.RelayBaseController;
import itx.core.web.WebRequest;
import itx.erp.base.model.WebSession;
import itx.r2b.RtobObjectContainer;
import itx.r2b.controller.app.message.CustomerMessages;
import itx.r2b.controller.app.message.WorkFeedbackMessages;
import itx.r2b.controller.app.message.WorkHourMessages;
import itx.r2b.controller.app.message.WorkOrderMessages;
import java.io.IOException;
import java.util.HashMap;

public class RtobMessageController
extends RelayBaseController {
    protected CustomerMessages customerMessages;
    protected WorkOrderMessages workOrderMessages;
    protected WorkHourMessages workHourMessages;
    protected WorkFeedbackMessages workFeedbackMessages;

    public CustomerMessages getCustomerMessages() {
        return this.customerMessages;
    }

    public void setCustomerMessages(CustomerMessages customerMessages) {
        this.customerMessages = customerMessages;
    }

    public WorkOrderMessages getWorkOrderMessages() {
        return this.workOrderMessages;
    }

    public void setWorkOrderMessages(WorkOrderMessages workOrderMessages) {
        this.workOrderMessages = workOrderMessages;
    }

    public WorkHourMessages getWorkHourMessages() {
        return this.workHourMessages;
    }

    public void setWorkHourMessages(WorkHourMessages workHourMessages) {
        this.workHourMessages = workHourMessages;
    }

    public WorkFeedbackMessages getWorkFeedbackMessages() {
        return this.workFeedbackMessages;
    }

    public void setWorkFeedbackMessages(WorkFeedbackMessages workFeedbackMessages) {
        this.workFeedbackMessages = workFeedbackMessages;
    }

    @Override
    public boolean checkAuthentication(WebRequest req) throws Exception {
        String jtbauth = req.getParameter("jtbauth");
        WebSession s = RtobObjectContainer.getInstance().getWebSessionService().readSession(jtbauth);
        if (s != null) {
            req.setWebSession(s);
            return true;
        }
        return false;
    }

    public void indexAction(WebRequest req) throws StreamWriteException, DatabindException, IOException {
        String msg = req.getParameter("message");
        Object error = "Unknown error, action not handled";
        try {
            if ("validateCustomer".equals(msg)) {
                this.customerMessages.validateCustomerAction(req);
                return;
            }
            if ("saveCustomer".equals(msg)) {
                this.customerMessages.saveAction(req);
                return;
            }
            if ("deleteCustomer".equals(msg)) {
                this.customerMessages.deleteAction(req);
                return;
            }
            if ("saveWork".equals(msg)) {
                this.workOrderMessages.saveAction(req);
                return;
            }
            if ("deleteWork".equals(msg)) {
                this.workOrderMessages.deleteAction(req);
                return;
            }
            if ("saveHour".equals(msg)) {
                this.workHourMessages.saveAction(req);
                return;
            }
            if ("deleteHour".equals(msg)) {
                this.workHourMessages.deleteAction(req);
                return;
            }
            if ("saveFeedback".equals(msg)) {
                this.workFeedbackMessages.saveAction(req);
                return;
            }
            if ("deleteFeedback".equals(msg)) {
                this.workFeedbackMessages.deleteAction(req);
                return;
            }
            error = "Unknown message received: " + msg;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            error = "Error: " + ex.getMessage();
        }
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("error", true);
        r.put("message", error);
        req.renderJson(r);
    }
}

