/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.controller.app;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.RelayBaseController;
import itx.core.web.WebRequest;
import itx.erp.base.model.DbFile;
import itx.erp.base.model.WebSession;
import itx.erp.base.service.FileService;
import itx.erp.helper.ErpConfig;
import itx.r2b.RtobObjectContainer;
import itx.r2b.model.SimpleForm;
import itx.r2b.model.WorkOrder;
import itx.r2b.service.SimpleFormService;
import itx.r2b.service.WorkOrderService;
import jakarta.servlet.ServletOutputStream;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import javax.imageio.ImageIO;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.AuthorizationException;
import jtbcore.exception.JTBException;
import jtbcore.util.DateUtil;
import jtbcore.util.FileUtil;
import jtbcore.util.ImageUtil;

public class RtobWorkController
extends RelayBaseController {
    protected WorkOrderService workOrderService;
    protected SimpleFormService simpleFormService;
    protected FileService fileService;

    public WorkOrderService getWorkOrderService() {
        return this.workOrderService;
    }

    public void setWorkOrderService(WorkOrderService workOrderService) {
        this.workOrderService = workOrderService;
    }

    public SimpleFormService getSimpleFormService() {
        return this.simpleFormService;
    }

    public void setSimpleFormService(SimpleFormService simpleFormService) {
        this.simpleFormService = simpleFormService;
    }

    public FileService getFileService() {
        return this.fileService;
    }

    public void setFileService(FileService fileService) {
        this.fileService = fileService;
    }

    @Override
    public boolean checkAuthentication(WebRequest req) throws Exception {
        String jtbauth = req.getParameter("jtbauth");
        WebSession s = RtobObjectContainer.getInstance().getWebSessionService().readSession(jtbauth);
        if (s != null) {
            req.setWebSession(s);
            return true;
        }
        return false;
    }

    public void searchAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException, AuthorizationException {
        Integer start = req.getParamInt("start", 0);
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("start", start);
        opts.put("pageSize", this.listLimit);
        opts.put("q", req.getParameter("q"));
        if (req.hasParameter("cid")) {
            opts.put("cid", req.getParamInt("cid"));
        }
        if (req.hasParameter("uid")) {
            opts.put("uid", req.getParamIntStripPrefix("uid"));
        }
        if (req.hasParameter("sd")) {
            opts.put("startDate", req.getParamDate("startDate"));
        }
        if (req.hasParameter("ed")) {
            opts.put("endDate", req.getParamDate("endDate"));
        }
        if (req.hasParameter("status")) {
            opts.put("status", req.getParameter("status"));
        }
        QueryResult<WorkOrder> qrs = this.workOrderService.searchWork(opts, req.getUserId());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("workOrders", qrs.getObjects());
        result.put("start", qrs.getStart());
        result.put("pageSize", qrs.getPageSize());
        result.put("rowCount", qrs.getRowCount());
        req.renderJson(result);
    }

    public void viewAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer woId = req.getParamInt("workOrderId");
        WorkOrder wo = this.workOrderService.readWork(woId, req.getUserId());
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("success", true);
        r.put("work", wo);
        req.renderJson(r);
    }

    public void defaultWorkOrderAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        SimpleForm defaultForm = this.simpleFormService.readDefaultSelected();
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("success", true);
        r.put("defaultForm", defaultForm);
        req.renderJson(r);
    }

    public void thumbAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer id = req.getParamInt("fid");
        DbFile f = null;
        if (id != null) {
            f = this.fileService.readFile(id);
        }
        if (f == null) {
            HashMap<String, Object> r = new HashMap<String, Object>();
            r.put("error", true);
            r.put("message", "File not found");
            req.renderJson(r);
            return;
        }
        ServletOutputStream os = req.getResponse().getOutputStream();
        String ext = FileUtil.extension(f.getOriginalFilename());
        if ("jpg".equals(ext) || "jpeg".equals(ext) || "png".equals(ext) || "gif".equals(ext)) {
            BufferedImage img = ImageIO.read(new File(f.getSystemPath()));
            BufferedImage img2 = ImageUtil.resize(img, 100, 100);
            req.getResponse().setContentType("image/jpg");
            ImageUtil.writeAsJpegToOutputStream(img2, 0.7f, (OutputStream)os);
            return;
        }
        req.getResponse().setContentType("image/png");
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        if (f.getEdited() != null) {
            req.getResponse().setHeader("Last-Modified", format.format(f.getEdited()));
        }
        req.getResponse().setHeader("Expires", format.format(DateUtil.nextDay(365)));
        req.getResponse().setHeader("Cache-Control", "max-age=31536000, immutable");
        Throwable throwable = null;
        Object var8_12 = null;
        try (InputStream is = ErpConfig.getResourceAsInput("/itx/erp/resources/file-100x100.png");){
            FileUtil.copy(is, (OutputStream)os);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

