/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.controller.app.message;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import itx.core.web.WebRequest;
import itx.r2b.model.WorkFeedback;
import itx.r2b.service.WorkFeedbackService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import jtbcore.exception.JTBException;
import jtbcore.model.KeyValueList;
import jtbcore.util.NumberUtil;

public class WorkFeedbackMessages {
    protected WorkFeedbackService workFeedbackService;

    public WorkFeedbackService getWorkFeedbackService() {
        return this.workFeedbackService;
    }

    public void setWorkFeedbackService(WorkFeedbackService workFeedbackService) {
        this.workFeedbackService = workFeedbackService;
    }

    protected WorkFeedback buildFeedback(WebRequest req) throws SQLException, JTBException, JsonMappingException, JsonProcessingException {
        WorkFeedback wf;
        KeyValueList kvlh = req.getKvl().getObject("data");
        Integer workFeedbackId = kvlh.getValueInt("workFeedbackId");
        if (workFeedbackId != null) {
            wf = this.workFeedbackService.readFeedback(workFeedbackId, req.getUserId());
        } else {
            wf = new WorkFeedback();
            wf.setUserId(req.getUserId());
        }
        wf.setStatus(kvlh.getValue("status"));
        wf.setFeedbackType(kvlh.getValue("feedbackType"));
        wf.setDeadline(kvlh.getValueDate("deadline"));
        String deadlineTime = kvlh.getValue("deadlineTime");
        if (deadlineTime == null || !deadlineTime.matches("^\\d\\d:\\d\\d$")) {
            deadlineTime = "00:00";
        }
        String[] toks = deadlineTime.split(":");
        Integer hour = NumberUtil.tryParseInt(toks[0]);
        Integer mins = NumberUtil.tryParseInt(toks[1]);
        if (hour >= 0 && hour <= 23 && mins >= 0 && mins <= 59) {
            Date d = wf.getDeadline();
            if (d == null) {
                d = new Date();
                d.setSeconds(0);
                d.setHours(0);
                d.setMinutes(0);
            }
            d.setHours(hour);
            d.setMinutes(mins);
            wf.setDeadline(d);
        }
        wf.setCustomerId(kvlh.getValueInt("customerId"));
        wf.setShortDescription(kvlh.getValueTrim("shortDescription"));
        wf.setLongDescription(kvlh.getValue("longDescription"));
        return wf;
    }

    public void saveAction(WebRequest req) throws SQLException, JTBException, IOException {
        WorkFeedback wf = this.buildFeedback(req);
        this.workFeedbackService.save(wf, req.getUserId());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("workId", wf.getWorkFeedbackId());
        result.put("feedback", wf);
        req.renderJson(result);
    }

    public void deleteAction(WebRequest req) throws SQLException, JTBException, IOException {
        Integer workFeedbackId = req.getParamInt("data");
        this.workFeedbackService.deleteFeedback(workFeedbackId, req.getUserId());
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }
}

