/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.controller.app.message;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import itx.core.web.WebRequest;
import itx.r2b.model.WorkHour;
import itx.r2b.service.WorkHourService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import jtbcore.exception.InvalidStateException;
import jtbcore.exception.JTBException;
import jtbcore.model.KeyValueList;
import jtbcore.util.NumberUtil;

public class WorkHourMessages {
    protected WorkHourService workHourService;

    public WorkHourService getWorkHourService() {
        return this.workHourService;
    }

    public void setWorkHourService(WorkHourService workHourService) {
        this.workHourService = workHourService;
    }

    protected WorkHour buildHour(WebRequest req) throws SQLException, JTBException, JsonMappingException, JsonProcessingException {
        Date d;
        WorkHour wh;
        KeyValueList kvlh = req.getKvl().getObject("data");
        Integer workHourId = kvlh.getValueInt("workHourId");
        if (workHourId != null) {
            wh = this.workHourService.readHour(workHourId, req.getUserId());
        } else {
            wh = new WorkHour();
            wh.setUserId(req.getUserId());
        }
        wh.setCustomerId(kvlh.getValueInt("customerId"));
        wh.setShortDescription(kvlh.getValueTrim("shortDescription"));
        wh.setTimingType(kvlh.getValue("timingType"));
        wh.setStartTime(kvlh.getValueDate("startDate"));
        String startTime = kvlh.getValue("startTime");
        if (startTime == null || !startTime.matches("^\\d\\d:\\d\\d$")) {
            startTime = "00:00";
        }
        String[] toks = startTime.split(":");
        Integer hour = NumberUtil.tryParseInt(toks[0]);
        Integer mins = NumberUtil.tryParseInt(toks[1]);
        if (hour >= 0 && hour <= 23 && mins >= 0 && mins <= 59) {
            d = wh.getStartTime();
            if (d == null) {
                d = new Date();
                d.setSeconds(0);
                d.setHours(0);
                d.setMinutes(0);
            }
            d.setHours(hour);
            d.setMinutes(mins);
            wh.setStartTime(d);
        }
        wh.setEndTime(kvlh.getValueDate("endDate"));
        String endTime = kvlh.getValue("endTime");
        if (endTime == null || !endTime.matches("^\\d\\d:\\d\\d$")) {
            endTime = "00:00";
        }
        toks = endTime.split(":");
        hour = NumberUtil.tryParseInt(toks[0]);
        mins = NumberUtil.tryParseInt(toks[1]);
        if (hour >= 0 && hour <= 23 && mins >= 0 && mins <= 59) {
            d = wh.getEndTime();
            if (d == null) {
                d = new Date();
                d.setSeconds(0);
                d.setHours(0);
                d.setMinutes(0);
            }
            d.setHours(hour);
            d.setMinutes(mins);
            wh.setEndTime(d);
        }
        wh.setDuration(kvlh.getValueDouble("duration"));
        wh.setLongDescription(kvlh.getValue("longDescription"));
        return wh;
    }

    public void saveAction(WebRequest req) throws SQLException, JTBException, IOException {
        WorkHour oldwh;
        WorkHour wh = this.buildHour(req);
        if (wh.getWorkHourId() != null && !"open".equals((oldwh = this.workHourService.readHour(wh.getWorkHourId(), req.getUserId())).getReportStatus())) {
            throw new InvalidStateException("WorkHour already processed. Unable to update..");
        }
        this.workHourService.save(wh, req.getUserId());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("workHourId", wh.getWorkHourId());
        result.put("hour", wh);
        req.renderJson(result);
    }

    public void deleteAction(WebRequest req) throws SQLException, JTBException, IOException {
        Integer workHourId = req.getParamInt("data");
        this.workHourService.deleteHour(workHourId, req.getUserId());
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }
}

