/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.controller.app.message;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.JsonMappingException;
import itx.core.web.WebRequest;
import itx.erp.base.model.DbFile;
import itx.erp.base.model.User;
import itx.erp.base.service.FileService;
import itx.erp.base.service.UserService;
import itx.r2b.RtobObjectContainer;
import itx.r2b.model.WorkOrder;
import itx.r2b.model.WorkWidget;
import itx.r2b.service.WorkOrderService;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import jtbcore.exception.InvalidStateException;
import jtbcore.exception.JTBException;
import jtbcore.model.KeyValueList;
import jtbcore.util.FileUtil;
import jtbcore.util.NumberUtil;

public class WorkOrderMessages {
    protected WorkOrderService workOrderService;
    protected FileService fileService;
    protected UserService userService;

    public WorkOrderService getWorkOrderService() {
        return this.workOrderService;
    }

    public void setWorkOrderService(WorkOrderService workOrderService) {
        this.workOrderService = workOrderService;
    }

    public FileService getFileService() {
        return this.fileService;
    }

    public void setFileService(FileService fileService) {
        this.fileService = fileService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    protected WorkOrder buildWork(WebRequest req) throws SQLException, JTBException, JsonMappingException, JsonProcessingException {
        WorkOrder wo;
        KeyValueList kvl = KeyValueList.fromJson(req.getParameter("data"));
        Integer workOrderId = kvl.getValueInt("workOrderId");
        if (workOrderId != null) {
            wo = this.workOrderService.readWork(workOrderId, req.getUserId());
        } else {
            wo = new WorkOrder();
            wo.setUserId(req.getUserId());
        }
        wo.setCustomerId(kvl.getValueInt("customerId"));
        wo.setDescription(kvl.getValueTrim("description"));
        wo.setLocationText(kvl.getValueTrim("location"));
        wo.setOrderDate(kvl.getValueDate("orderDate"));
        String orderTime = kvl.getValue("orderTime");
        if (orderTime == null || !orderTime.matches("^\\d\\d:\\d\\d$")) {
            orderTime = "00:00";
        }
        String[] toks = orderTime.split(":");
        Integer hour = NumberUtil.tryParseInt(toks[0]);
        Integer mins = NumberUtil.tryParseInt(toks[1]);
        if (hour >= 0 && hour <= 23 && mins >= 0 && mins <= 59) {
            Date d = wo.getOrderDate();
            if (d == null) {
                d = new Date();
                d.setSeconds(0);
                d.setHours(0);
                d.setMinutes(0);
            }
            d.setHours(hour);
            d.setMinutes(mins);
            wo.setOrderDate(d);
        }
        ArrayList<WorkWidget> posted_workWidgets = new ArrayList<WorkWidget>();
        List<KeyValueList> kvl_widgets = kvl.getList("widgets");
        int x = 0;
        while (x < kvl_widgets.size()) {
            KeyValueList kvlw = kvl_widgets.get(x);
            WorkWidget ww = null;
            Integer workWidgetId = kvlw.getValueInt("workWidgetId");
            if (workWidgetId != null) {
                for (WorkWidget old_ww : wo.getWidgets()) {
                    if (!old_ww.getWorkWidgetId().equals(workWidgetId)) continue;
                    ww = old_ww;
                    break;
                }
            }
            if (ww == null) {
                ww = new WorkWidget();
            }
            ww.setWorkWidgetId(workWidgetId);
            ww.setWidgetType(kvlw.getValue("widgetType"));
            if (kvlw.hasValue("label")) {
                ww.setWidgetLabel(kvlw.getValueTrim("label"));
            }
            if (kvlw.hasValue("value")) {
                ww.setWidgetValue1(kvlw.getValueTrim("value"));
            }
            posted_workWidgets.add(ww);
            ++x;
        }
        wo.setWidgets(posted_workWidgets);
        return wo;
    }

    public void saveAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException, ServletException {
        WorkOrder wo_old;
        WorkOrder wo = this.buildWork(req);
        if (wo.getWorkOrderId() != null && !"open".equals((wo_old = this.workOrderService.readWork(wo.getWorkOrderId(), req.getUserId())).getStatus())) {
            throw new InvalidStateException("WorkOrder not writable, status: " + wo_old.getStatus());
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.workOrderService.saveApp(wo, req.getUserId());
        Part p = req.getRequest().getPart("file");
        if (p != null && p.getSize() > 0L) {
            User user = this.userService.readUser(req.getUserId());
            DbFile f = new DbFile();
            f.setOriginalFilename(p.getSubmittedFileName());
            f.setRefDescription("Uploaded from App by " + user.getUsername());
            f.setNote(req.getParameter("note"));
            this.fileService.saveFile(user, f, true);
            String path = String.valueOf(f.getDbFileId()) + "-" + f.getOriginalFilename();
            f.setPath(path);
            String file = RtobObjectContainer.getInstance().getFilesDir() + "/" + path;
            InputStream is = p.getInputStream();
            Integer s = FileUtil.inputStream2File(is, file);
            f.setSize(s);
            is.close();
            this.fileService.saveFile(user, f, false);
            this.workOrderService.linkFile(wo.getWorkOrderId(), f.getDbFileId());
        }
        result.put("success", true);
        result.put("work", wo);
        req.renderJson(result);
    }

    public void deleteAction(WebRequest req) throws SQLException, JTBException, IOException {
        Integer workOrderId = req.getParamInt("data");
        this.workOrderService.deleteWork(workOrderId, req.getUserId());
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }
}

