/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.controller.auth;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.base.model.User;
import itx.erp.base.model.WebSession;
import itx.erp.base.service.UserService;
import itx.erp.base.service.WebSessionService;
import itx.erp.webmail.conf.EmailSettings;
import itx.erp.webmail.model.EmailMessage;
import itx.erp.webmail.model.EmailTemplate;
import itx.erp.webmail.service.EmailService;
import itx.erp.webmail.service.EmailTemplateService;
import itx.r2b.conf.RtobConf;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import javax.mail.MessagingException;
import jtbcore.exception.AuthorizationException;
import jtbcore.exception.JTBException;
import jtbcore.exception.RemoteApiException;
import jtbcore.util.StringUtil;

public class AppLoginLinkController
extends BaseController {
    protected EmailService emailService;
    protected EmailTemplateService emailTemplateService;
    protected EmailSettings emailSettings;
    protected UserService userService;
    protected WebSessionService webSessionService;

    public EmailService getEmailService() {
        return this.emailService;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    public EmailTemplateService getEmailTemplateService() {
        return this.emailTemplateService;
    }

    public void setEmailTemplateService(EmailTemplateService emailTemplateService) {
        this.emailTemplateService = emailTemplateService;
    }

    public EmailSettings getEmailSettings() {
        return this.emailSettings;
    }

    public void setEmailSettings(EmailSettings emailSettings) {
        this.emailSettings = emailSettings;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public WebSessionService getWebSessionService() {
        return this.webSessionService;
    }

    public void setWebSessionService(WebSessionService webSessionService) {
        this.webSessionService = webSessionService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        super.executeAction(webRequest);
    }

    public void indexAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException, JTBException, MessagingException, RemoteApiException {
        User reqUser = this.userService.readUser(req.getUserId());
        if (!reqUser.isAdmin()) {
            throw new AuthorizationException("Access denied");
        }
        Integer userId = req.getParamInt("userId");
        String email = req.getParameter("email");
        User user = this.userService.readUser(userId);
        WebSession webses = this.webSessionService.createSession(user, 2592000);
        EmailTemplate t = this.emailTemplateService.readByCode("R2B_APP_AUTH");
        String content = t.getContent();
        RtobConf rtobConf = RtobConf.getInstance();
        String link = rtobConf.getAppUrl() + "?relay=" + rtobConf.getRelayName() + "&jtbauth=" + webses.getCookieValue();
        content = content.replaceAll("\\[\\[link\\]\\]", link);
        EmailMessage m = new EmailMessage();
        if (!StringUtil.isEmpty(t.getFromName())) {
            m.setFromName(t.getFromName());
        } else {
            m.setFromEmail(this.emailSettings.getFromName());
        }
        if (!StringUtil.isEmpty(t.getFromEmail())) {
            m.setFromEmail(t.getFromEmail());
        } else {
            m.setFromEmail(this.emailSettings.getFromEmail());
        }
        m.setSubject(t.getSubject());
        m.setTextContent(content);
        m.addTo(email, user.getUsername());
        this.emailService.sendMail(m);
        HashMap<String, Boolean> r = new HashMap<String, Boolean>();
        r.put("success", true);
        req.renderJson(r);
    }
}

