/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.controller.reporting;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.base.util.LangUtil;
import itx.r2b.RtobObjectContainer;
import itx.r2b.reports.WorkHourReportV1;
import itx.r2b.service.WorkOrderService;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jtbcore.db.common.SqlConnection;
import jtbcore.db.export.ExcelExporter;
import jtbcore.exception.FileException;
import jtbcore.exception.InvalidArgument;
import jtbcore.exception.JTBException;
import jtbcore.model.KeyValueList;
import jtbcore.util.FileUtil;
import jtbcore.util.ProcUtil;

public class WorkHourReportController
extends BaseController {
    protected SqlConnection connection;
    protected WorkOrderService workOrderService;

    public SqlConnection getConnection() {
        return this.connection;
    }

    public void setConnection(SqlConnection connection) {
        this.connection = connection;
    }

    public WorkOrderService getWorkOrderService() {
        return this.workOrderService;
    }

    public void setWorkOrderService(WorkOrderService workOrderService) {
        this.workOrderService = workOrderService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        super.executeAction(webRequest);
    }

    public void indexAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException, InvalidArgument {
        WorkHourReportV1 r = new WorkHourReportV1();
        r.setConnection(this.connection);
        if (req.hasParameter("customerId")) {
            r.setCustomerId(req.getParamInt("customerId"));
        }
        if (req.hasParameter("startDate")) {
            r.setStartDate(req.getParamDate("startDate"));
        }
        if (req.hasParameter("endDate")) {
            r.setEndDate(req.getParamDate("endDate"));
        }
        if (req.getParamBool("rsOpen").booleanValue()) {
            r.addReportStatus("open");
        }
        if (req.getParamBool("rsInprogress").booleanValue()) {
            r.addReportStatus("inprogress");
        }
        if (req.getParamBool("rsCancelled").booleanValue()) {
            r.addReportStatus("cancelled");
        }
        if (req.getParamBool("rsProcessed").booleanValue()) {
            r.addReportStatus("processed");
        }
        req.getParamBool("rsOpen").booleanValue();
        if (req.hasParameter("widgetType")) {
            r.setWidgetType(req.getParameter("widgetType"));
        }
        List<Map<String, Object>> lines = r.buildReport();
        String customerName = null;
        if (r.getCustomerId() != null) {
            customerName = (String)this.connection.queryValue("select customer_name from customer__customer where customer_id = ?", String.class, r.getCustomerId());
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("customerName", customerName);
        result.put("customerId", r.getCustomerId());
        result.put("lines", lines);
        result.put("totalPrice", r.getTotalPrice());
        result.put("totalNumbers", r.getTotalNumbers());
        result.put("totalDuration", r.getTotalDuration());
        req.renderJson(result);
    }

    public void updateAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException, JTBException {
        HashMap<CallSite, String> updatedStatus = new HashMap<CallSite, String>();
        ArrayList<Integer> workOrderIds = new ArrayList<Integer>();
        KeyValueList kvl = req.getKvl();
        String newStatus = kvl.getValue("newStatus");
        List<KeyValueList> lines = kvl.getList("lines");
        for (KeyValueList l : lines) {
            Integer workOrderId;
            String widgetType = l.getValue("widget_type");
            Integer refId = l.getValueInt("ref_id");
            String refTable = null;
            if ("SFHourWidget".equals(widgetType) || "SFHourLabelWidget".equals(widgetType) || "SFMoneyWidget".equals(widgetType) || "SFMoneyLabelWidget".equals(widgetType) || "SFNumberWidget".equals(widgetType) || "SFNumberLabelWidget".equals(widgetType)) {
                refTable = "work_widget";
            } else if ("WorkHour".equals(widgetType)) {
                refTable = "work_hour";
            }
            if (refTable == null) {
                System.err.println("Error, ref table not found for: " + widgetType + " - " + String.valueOf(refId));
                continue;
            }
            Integer r = (Integer)this.connection.queryValue("select ref_id from rtob__report_record_status where ref_id=? and ref_table=?", Integer.class, refId, refTable);
            if (r == null) {
                this.connection.query("insert into rtob__report_record_status (ref_id, ref_table, status) values (?, ?, ?)", refId, refTable, newStatus);
            } else {
                this.connection.query("update rtob__report_record_status set status = ? where ref_id = ? and ref_table = ?", newStatus, refId, refTable);
            }
            updatedStatus.put((CallSite)((Object)(widgetType + "-" + String.valueOf(refId))), newStatus);
            if (!"work_widget".equals(refTable) || workOrderIds.indexOf(workOrderId = (Integer)this.connection.queryValue("select work_order_id from rtob__work_widget where work_widget_id = ?", Integer.class, refId)) != -1) continue;
            workOrderIds.add(workOrderId);
        }
        int x = 0;
        while (x < workOrderIds.size()) {
            this.workOrderService.autoUpdateStatus((Integer)workOrderIds.get(x), req.getUserId());
            ++x;
        }
        HashMap<String, Serializable> r = new HashMap<String, Serializable>();
        r.put("success", Boolean.valueOf(true));
        r.put("updatedStatus", updatedStatus);
        req.renderJson(r);
    }

    public void exportAction(WebRequest req) throws SQLException, FileException, IOException, InvalidArgument {
        LangUtil lu = LangUtil.getInstance();
        WorkHourReportV1 r = new WorkHourReportV1();
        r.setConnection(this.connection);
        if (req.hasParameter("cid")) {
            r.setCustomerId(req.getParamInt("cid"));
        }
        if (req.hasParameter("s")) {
            r.setStartDate(req.getParamDate("s"));
        }
        if (req.hasParameter("e")) {
            r.setEndDate(req.getParamDate("e"));
        }
        if (req.getParamBool("rsOpen").booleanValue()) {
            r.addReportStatus("open");
        }
        if (req.getParamBool("rsInprogress").booleanValue()) {
            r.addReportStatus("inprogress");
        }
        if (req.getParamBool("rsCancelled").booleanValue()) {
            r.addReportStatus("cancelled");
        }
        if (req.getParamBool("rsProcessed").booleanValue()) {
            r.addReportStatus("processed");
        }
        List<Map<String, Object>> lines = r.buildReport();
        String path = RtobObjectContainer.getInstance().getTempFile("wh-export.xlsx");
        ExcelExporter e = new ExcelExporter(path);
        e.writeHeader(new String[]{"Type", "Relatie", "Omschrijving", "Start", "Einde", "Uren", "Aantallen", "Prijs", "Rapport status"});
        for (Map<String, Object> l : lines) {
            Object[] el = new Object[]{lu.t("widgetType.description." + String.valueOf(l.get("widget_type"))), l.get("customer_name"), l.get("description"), l.get("entry_date"), l.get("end_time"), l.get("duration"), l.get("number"), l.get("price"), lu.t("reportStatus." + String.valueOf(l.get("status")))};
            e.writeRow(el);
        }
        e.closeFile();
        if (req.isEmbeddedRequest()) {
            f = new File(path);
            ProcUtil.openUrlInBrowser(f.getAbsolutePath());
        } else {
            f = new File(path);
            HttpServletResponse response = req.getResponse();
            response.setHeader("Content-type", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setHeader("Content-Disposition", "attachment; filename=\"" + f.getName() + "\"");
            ServletOutputStream os = response.getOutputStream();
            FileUtil.file2outputstream(f, (OutputStream)os);
            os.close();
            f.delete();
        }
    }
}

