/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.controller.simpleform;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.ObjectMapper;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.r2b.model.SimpleForm;
import itx.r2b.model.SimpleFormWidget;
import itx.r2b.service.SimpleFormService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import jtbcore.exception.JTBException;
import jtbcore.model.KeyValueList;

public class SimpleFormEditController
extends BaseController {
    protected SimpleFormService simpleFormService;

    public SimpleFormService getSimpleFormService() {
        return this.simpleFormService;
    }

    public void setSimpleFormService(SimpleFormService simpleFormService) {
        this.simpleFormService = simpleFormService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        super.executeAction(webRequest);
    }

    public void viewAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer formId = req.getParamInt("id");
        SimpleForm f = this.simpleFormService.readForm(formId);
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("success", true);
        r.put("form", f);
        req.renderJson(r);
    }

    public void saveAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer formId = req.getParamInt("simpleFormId");
        Boolean active = req.getParamBool("active");
        String name = req.getParameter("name");
        List<KeyValueList> kvlWidgets = req.getKvl().getList("widgets");
        SimpleForm f = null;
        f = formId != null && formId > 0 ? this.simpleFormService.readForm(formId) : new SimpleForm();
        f.setActive(active);
        f.setDefaultSelected(req.getParamBool("defaultSelected"));
        f.setName(name);
        f.clearWidgets();
        for (KeyValueList lw : kvlWidgets) {
            SimpleFormWidget w = new SimpleFormWidget();
            w.setWidgetType(lw.getValue("type"));
            w.setWidgetLabel(lw.getValue("label"));
            w.setWidgetValue1(lw.getValue("value1"));
            ObjectMapper om = new ObjectMapper();
            String props = om.writeValueAsString(lw.flatList());
            w.setProperties(props);
            f.addWidget(w);
        }
        this.simpleFormService.save(f);
        HashMap<String, Comparable<Boolean>> r = new HashMap<String, Comparable<Boolean>>();
        r.put("success", Boolean.valueOf(true));
        r.put("simpleFormId", f.getSimpleFormId());
        req.renderJson(r);
    }

    public void deleteAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException {
        Integer id = req.getParamInt("simpleFormId");
        this.simpleFormService.deleteForm(id, req.getUserId());
        HashMap<String, Boolean> r = new HashMap<String, Boolean>();
        r.put("success", true);
        req.renderJson(r);
    }
}

