/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.controller.simpleform;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.helper.ErpConfig;
import itx.r2b.model.SimpleForm;
import itx.r2b.service.SimpleFormService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.JTBException;
import jtbcore.util.NumberUtil;

public class SimpleFormListController
extends BaseController {
    protected ErpConfig appConfig;
    protected SimpleFormService simpleFormService;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public SimpleFormService getSimpleFormService() {
        return this.simpleFormService;
    }

    public void setSimpleFormService(SimpleFormService simpleFormService) {
        this.simpleFormService = simpleFormService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        super.executeAction(webRequest);
    }

    public void indexAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException {
        Integer pageNo = req.getParamInt("pageNo", 0);
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("start", pageNo * this.appConfig.getLimit());
        opts.put("pageSize", 99999);
        opts.put("q", req.getParameter("q"));
        QueryResult<SimpleForm> qrs = this.simpleFormService.searchForms(opts);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("forms", qrs.getObjects());
        result.put("start", qrs.getStart());
        result.put("pageSize", qrs.getPageSize());
        result.put("rowCount", qrs.getRowCount());
        req.renderJson(result);
    }

    public void updateSortAction(WebRequest req) throws StreamWriteException, DatabindException, IOException, SQLException {
        List<Integer> ids = NumberUtil.csl2int(req.getParameter("ids"));
        this.simpleFormService.updateSortForms(ids);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("success", true);
        req.renderJson(result);
    }

    public void listActiveAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        List<SimpleForm> forms = this.simpleFormService.readActive();
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("success", true);
        r.put("forms", forms);
        req.renderJson(r);
    }
}

