/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.controller.websocket;

import itx.erp.ErpObjectContainer;
import itx.erp.base.model.WebSession;
import itx.r2b.controller.websocket.WebsocketClient;
import itx.r2b.controller.websocket.WebsocketClientHolder;
import java.io.IOException;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketConnectionListener;
import org.eclipse.jetty.websocket.api.WebSocketListener;

public class UpdateListenerWebsocket
implements WebSocketListener,
WebsocketClient,
WebSocketConnectionListener {
    protected Integer userId = null;
    protected boolean isAuthenticated = false;
    protected Session session = null;

    public void onWebSocketConnect(Session session) {
        WebsocketClientHolder.addClient(this);
        this.session = session;
    }

    public void onWebSocketClose(int statusCode, String reason) {
        WebsocketClientHolder.removeClient(this);
        this.session = null;
    }

    public void onWebSocketError(Throwable cause) {
        if (this.session != null && this.session.isOpen()) {
            try {
                this.session.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.session = null;
    }

    public void onWebSocketText(String message) {
        if (this.session == null || !this.session.isOpen()) {
            return;
        }
        if (message != null && message.startsWith("jtbauth:")) {
            String jtbauth_code = message.substring(8);
            try {
                WebSession s = ErpObjectContainer.getInstance().getWebSessionService().readSession(jtbauth_code);
                if (s == null) {
                    return;
                }
                this.userId = s.getUserId();
                this.isAuthenticated = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    @Override
    public synchronized void sendMessage(String msg) {
        if (this.session == null || !this.isAuthenticated) {
            return;
        }
        try {
            this.session.getRemote().sendString(msg);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

