/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.controller.work;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.ObjectMapper;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.base.model.UserPermission;
import itx.erp.base.service.UserService;
import itx.erp.customer.model.Customer;
import itx.erp.customer.service.CustomerService;
import itx.r2b.model.SimpleForm;
import itx.r2b.model.WorkOrder;
import itx.r2b.model.WorkOrderFile;
import itx.r2b.model.WorkWidget;
import itx.r2b.service.SimpleFormService;
import itx.r2b.service.WorkOrderService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import jtbcore.exception.JTBException;
import jtbcore.model.KeyValueList;
import jtbcore.util.DateUtil;
import jtbcore.util.NumberUtil;

public class WorkEditController
extends BaseController {
    protected WorkOrderService workOrderService;
    protected SimpleFormService simpleFormService;
    protected UserService userService;
    protected CustomerService customerService;

    public WorkOrderService getWorkOrderService() {
        return this.workOrderService;
    }

    public void setWorkOrderService(WorkOrderService workOrderService) {
        this.workOrderService = workOrderService;
    }

    public SimpleFormService getSimpleFormService() {
        return this.simpleFormService;
    }

    public void setSimpleFormService(SimpleFormService simpleFormService) {
        this.simpleFormService = simpleFormService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public CustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        super.executeAction(webRequest);
    }

    public void viewAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer woId = req.getParamInt("workOrderId");
        WorkOrder wo = this.workOrderService.readWork(woId, req.getUserId());
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("success", true);
        r.put("work", wo);
        req.renderJson(r);
    }

    public void defaultWorkOrderAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException, JTBException {
        List<UserPermission> ups = this.workOrderService.defaultPermissions(req.getUserId());
        WorkOrder wo = new WorkOrder();
        wo.setPermissions(ups);
        wo.setUserId(req.getUserId());
        wo.setOrderDate(DateUtil.oclock());
        wo.getBaseStringMap().setProperty("username", this.userService.getUsername(req.getUserId()));
        Integer selectedCid = req.getParamInt("selected_cid");
        if (selectedCid != null) {
            Customer cust = this.customerService.readCustomer(selectedCid);
            wo.setCustomerId(cust.getCustomerId());
            wo.getBaseStringMap().setProperty("customer_name", cust.getCustomerName());
        }
        SimpleForm form = this.simpleFormService.readDefaultSelected();
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("success", true);
        r.put("work", wo);
        r.put("defaultForm", form);
        req.renderJson(r);
    }

    public void saveAction(WebRequest req) throws SQLException, JTBException, IOException {
        Integer waId = req.getParamInt("workOrderId");
        Integer customerId = req.getParamInt("customerId");
        String description = req.getParameter("description");
        String locationText = req.getParameter("locationText");
        Date orderDate = null;
        String str_orderDate = req.getParameter("orderDate");
        if (DateUtil.validDateTime(str_orderDate)) {
            orderDate = req.getParamDateTime("orderDate");
        } else if (DateUtil.validDate(str_orderDate)) {
            orderDate = req.getParamDate("orderDate");
            orderDate.setHours(0);
        }
        String status = req.getParameter("status");
        Integer userId = null;
        String str_userId = req.getParameter("userId");
        userId = str_userId != null && str_userId.startsWith("user-") ? NumberUtil.tryParseInt(str_userId.substring(5)) : NumberUtil.tryParseInt(str_userId);
        List<KeyValueList> kvlWidgets = req.getKvl().getList("widgets");
        List<KeyValueList> kvlFiles = req.getKvl().getList("files");
        List<KeyValueList> kvlPermissions = req.getKvl().getList("permissions");
        WorkOrder wo = null;
        wo = waId != null && waId > 0 ? this.workOrderService.readWork(waId, req.getUserId()) : new WorkOrder();
        wo.setCustomerId(customerId);
        wo.setUserId(userId);
        wo.setDescription(description);
        wo.setLocationText(locationText);
        wo.setOrderDate(orderDate);
        wo.setStatus(status);
        wo.clearWidgets();
        for (KeyValueList lw : kvlWidgets) {
            WorkWidget w = new WorkWidget();
            w.setWidgetType(lw.getValue("type"));
            w.setWidgetLabel(lw.getValue("label"));
            w.setWidgetValue1(lw.getValue("value1"));
            String rs = lw.getValue("reportStatus");
            if (rs != null && rs.length() > 0) {
                w.setReportStatus(rs);
            }
            ObjectMapper om = new ObjectMapper();
            String props = om.writeValueAsString(lw.flatList());
            w.setProperties(props);
            wo.addWidget(w);
        }
        wo.clearFiles();
        for (KeyValueList lf : kvlFiles) {
            WorkOrderFile f = new WorkOrderFile();
            f.setDbFileId(lf.getValueInt("dbFileId"));
            wo.addFile(f);
        }
        ArrayList<UserPermission> perms = new ArrayList<UserPermission>();
        for (KeyValueList p : kvlPermissions) {
            UserPermission up;
            String refUserGroupId = p.getValue("refUserGroupId");
            if (refUserGroupId == null) continue;
            if (refUserGroupId.startsWith("user-")) {
                up = new UserPermission();
                up.setAccessMethod(p.getValue("accessMethod"));
                up.setUserId(NumberUtil.tryParseInt(refUserGroupId.substring(5)));
                perms.add(up);
            }
            if (!refUserGroupId.startsWith("group-")) continue;
            up = new UserPermission();
            up.setAccessMethod(p.getValue("accessMethod"));
            up.setGroupId(NumberUtil.tryParseInt(refUserGroupId.substring(6)));
            perms.add(up);
        }
        wo.setPermissions(perms);
        this.workOrderService.save(wo, req.getUserId());
        HashMap<String, Comparable<Boolean>> r = new HashMap<String, Comparable<Boolean>>();
        r.put("success", Boolean.valueOf(true));
        r.put("workOrderId", wo.getWorkOrderId());
        req.renderJson(r);
    }

    public void deleteAction(WebRequest req) throws SQLException, JTBException, IOException {
        Integer wo_id = req.getParamInt("workOrderId");
        this.workOrderService.deleteWork(wo_id, req.getUserId());
        HashMap<String, Boolean> r = new HashMap<String, Boolean>();
        r.put("success", true);
        req.renderJson(r);
    }
}

