/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.controller.workfeedback;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.base.model.UserPermission;
import itx.erp.base.service.UserService;
import itx.erp.customer.model.Customer;
import itx.erp.customer.service.CustomerService;
import itx.r2b.model.WorkFeedback;
import itx.r2b.service.WorkFeedbackService;
import itx.r2b.service.WorkOrderService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jtbcore.exception.JTBException;
import jtbcore.model.KeyValueList;
import jtbcore.util.NumberUtil;

public class WorkFeedbackEditController
extends BaseController {
    protected WorkFeedbackService workFeedbackService;
    protected WorkOrderService workOrderService;
    protected UserService userService;
    protected CustomerService customerService;

    public WorkFeedbackService getWorkFeedbackService() {
        return this.workFeedbackService;
    }

    public void setWorkFeedbackService(WorkFeedbackService workFeedbackService) {
        this.workFeedbackService = workFeedbackService;
    }

    public WorkOrderService getWorkOrderService() {
        return this.workOrderService;
    }

    public void setWorkOrderService(WorkOrderService workOrderService) {
        this.workOrderService = workOrderService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public CustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        super.executeAction(webRequest);
    }

    public void viewAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer fId = req.getParamInt("workFeedbackId");
        WorkFeedback f = this.workFeedbackService.readFeedback(fId, req.getUserId());
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("success", true);
        r.put("feedback", f);
        req.renderJson(r);
    }

    public void defaultFeedbackAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException, JTBException {
        List<UserPermission> ups = this.workOrderService.defaultPermissions(req.getUserId());
        WorkFeedback f = new WorkFeedback();
        f.setPermissions(ups);
        f.setUserId(req.getUserId());
        f.getBaseStringMap().setProperty("username", this.userService.getUsername(req.getUserId()));
        Integer selectedCid = req.getParamInt("selected_cid");
        if (selectedCid != null) {
            Customer cust = this.customerService.readCustomer(selectedCid);
            f.setCustomerId(cust.getCustomerId());
            f.getBaseStringMap().setProperty("customer_name", cust.getCustomerName());
        }
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("success", true);
        r.put("feedback", f);
        req.renderJson(r);
    }

    public void saveAction(WebRequest req) throws SQLException, JTBException, IOException {
        WorkFeedback f = null;
        f = req.hasParameter("workFeedbackId") ? this.workFeedbackService.readFeedback(req.getParamInt("workFeedbackId"), req.getUserId()) : new WorkFeedback();
        if (f.getWorkFeedbackId() != null) {
            f.setUserId(req.getUserId());
        }
        f.setStatus(req.getParameter("status"));
        f.setFeedbackType(req.getParameter("feedbackType"));
        f.setDeadline(req.getParamDateTime("deadline"));
        f.setCustomerId(req.getParamInt("customerId"));
        Integer userId = null;
        String str_userId = req.getParameter("userId");
        userId = str_userId != null && str_userId.startsWith("user-") ? NumberUtil.tryParseInt(str_userId.substring(5)) : NumberUtil.tryParseInt(str_userId);
        f.setUserId(userId);
        f.setShortDescription(req.getParameter("shortDescription"));
        f.setLongDescription(req.getParameter("longDescription"));
        List<KeyValueList> kvlPermissions = req.getKvl().getList("permissions");
        ArrayList<UserPermission> perms = new ArrayList<UserPermission>();
        for (KeyValueList p : kvlPermissions) {
            UserPermission up;
            String refUserGroupId = p.getValue("refUserGroupId");
            if (refUserGroupId == null) continue;
            if (refUserGroupId.startsWith("user-")) {
                up = new UserPermission();
                up.setAccessMethod(p.getValue("accessMethod"));
                up.setUserId(NumberUtil.tryParseInt(refUserGroupId.substring(5)));
                perms.add(up);
            }
            if (!refUserGroupId.startsWith("group-")) continue;
            up = new UserPermission();
            up.setAccessMethod(p.getValue("accessMethod"));
            up.setGroupId(NumberUtil.tryParseInt(refUserGroupId.substring(6)));
            perms.add(up);
        }
        f.setPermissions(perms);
        this.workFeedbackService.save(f, req.getUserId());
        HashMap<String, Comparable<Boolean>> r = new HashMap<String, Comparable<Boolean>>();
        r.put("success", Boolean.valueOf(true));
        r.put("workFeedbackId", f.getWorkFeedbackId());
        req.renderJson(r);
    }

    public void deleteAction(WebRequest req) throws StreamWriteException, DatabindException, IOException {
        Integer id = req.getParamInt("workFeedbackId");
        HashMap<String, Object> r = new HashMap<String, Object>();
        try {
            this.workFeedbackService.deleteFeedback(id, req.getUserId());
            r.put("success", true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            r.put("error", true);
            r.put("message", ex.getMessage());
        }
        req.renderJson(r);
    }
}

