/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.controller.workhour;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.base.model.UserPermission;
import itx.erp.base.service.UserService;
import itx.erp.customer.model.Customer;
import itx.erp.customer.service.CustomerService;
import itx.r2b.conf.RtobConf;
import itx.r2b.model.WorkHour;
import itx.r2b.model.validator.WorkHourValidator;
import itx.r2b.service.WorkHourService;
import itx.r2b.service.WorkOrderService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import jtbcore.exception.JTBException;
import jtbcore.model.KeyValueList;
import jtbcore.util.NumberUtil;

public class WorkHourEditController
extends BaseController {
    protected WorkHourService workHourService;
    protected WorkOrderService workOrderService;
    protected UserService userService;
    protected CustomerService customerService;
    protected RtobConf rtobConf = RtobConf.getInstance();

    public WorkHourService getWorkHourService() {
        return this.workHourService;
    }

    public void setWorkHourService(WorkHourService workHourService) {
        this.workHourService = workHourService;
    }

    public WorkOrderService getWorkOrderService() {
        return this.workOrderService;
    }

    public void setWorkOrderService(WorkOrderService workOrderService) {
        this.workOrderService = workOrderService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public CustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        super.executeAction(webRequest);
    }

    public void viewAction(WebRequest req) throws SQLException, JTBException, StreamWriteException, DatabindException, IOException {
        Integer whId = req.getParamInt("workHourId");
        WorkHour wh = this.workHourService.readHour(whId, req.getUserId());
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("success", true);
        r.put("hour", wh);
        req.renderJson(r);
    }

    public void defaultHourAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException, JTBException {
        List<UserPermission> ups = this.workOrderService.defaultPermissions(req.getUserId());
        WorkHour wh = new WorkHour();
        wh.setPermissions(ups);
        wh.setUserId(req.getUserId());
        wh.getBaseStringMap().setProperty("username", this.userService.getUsername(req.getUserId()));
        Integer selectedCid = req.getParamInt("selected_cid");
        if (selectedCid != null) {
            Customer cust = this.customerService.readCustomer(selectedCid);
            wh.setCustomerId(cust.getCustomerId());
            wh.getBaseStringMap().setProperty("customer_name", cust.getCustomerName());
        }
        wh.setTimingType(this.rtobConf.getHoursDefaultTimingType());
        Date startTime = new Date();
        startTime.setHours(0);
        startTime.setMinutes(0);
        startTime.setSeconds(0);
        wh.setStartTime(startTime);
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("success", true);
        r.put("hour", wh);
        req.renderJson(r);
    }

    public void saveAction(WebRequest req) throws SQLException, JTBException, IOException {
        Date et;
        Date st;
        WorkHour h = null;
        h = req.hasParameter("workHourId") ? this.workHourService.readHour(req.getParamInt("workHourId"), req.getUserId()) : new WorkHour();
        if (h.getWorkHourId() != null) {
            h.setUserId(req.getUserId());
        }
        h.setReportStatus(req.getParameter("reportStatus"));
        h.setCustomerId(req.getParamInt("customerId"));
        if (req.hasParameter("userId") && req.getParameter("userId").startsWith("user-")) {
            String str_userId = req.getParameter("userId").substring(5);
            h.setUserId(NumberUtil.tryParseInt(str_userId));
        } else {
            h.setUserId(req.getParamInt("userId"));
        }
        h.setShortDescription(req.getParameter("shortDescription"));
        h.setTimingType(req.getParameter("timingType"));
        h.setStartTime(req.getParamDateTime("startTime"));
        if (h.getStartTime() == null && (st = req.getParamDate("startTime")) != null) {
            st.setHours(0);
            h.setStartTime(st);
        }
        h.setEndTime(req.getParamDateTime("endTime"));
        if (h.getEndTime() == null && (et = req.getParamDate("endTime")) != null) {
            et.setHours(0);
            h.setEndTime(et);
        }
        h.setDuration(req.getParamDouble("duration"));
        h.setLongDescription(req.getParameter("longDescription"));
        if (h.getWorkHourId() == null) {
            h.setUserId(req.getUserId());
        }
        List<KeyValueList> kvlPermissions = req.getKvl().getList("permissions");
        ArrayList<UserPermission> perms = new ArrayList<UserPermission>();
        for (KeyValueList p : kvlPermissions) {
            UserPermission up;
            String refUserGroupId = p.getValue("refUserGroupId");
            if (refUserGroupId == null) continue;
            if (refUserGroupId.startsWith("user-")) {
                up = new UserPermission();
                up.setAccessMethod(p.getValue("accessMethod"));
                up.setUserId(NumberUtil.tryParseInt(refUserGroupId.substring(5)));
                perms.add(up);
            }
            if (!refUserGroupId.startsWith("group-")) continue;
            up = new UserPermission();
            up.setAccessMethod(p.getValue("accessMethod"));
            up.setGroupId(NumberUtil.tryParseInt(refUserGroupId.substring(6)));
            perms.add(up);
        }
        h.setPermissions(perms);
        WorkHourValidator v = new WorkHourValidator();
        HashMap<String, Object> r = new HashMap<String, Object>();
        if (v.validate(h)) {
            this.workHourService.save(h, req.getUserId());
            r.put("success", true);
            r.put("workHourId", h.getWorkHourId());
        } else {
            r.put("error", true);
            r.put("errors", v.getErrors());
        }
        req.renderJson(r);
    }

    public void deleteAction(WebRequest req) throws StreamWriteException, DatabindException, IOException {
        Integer id = req.getParamInt("workHourId");
        HashMap<String, Object> r = new HashMap<String, Object>();
        try {
            this.workHourService.deleteHour(id, req.getUserId());
            r.put("success", true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            r.put("error", true);
            r.put("message", ex.getMessage());
        }
        req.renderJson(r);
    }
}

