/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.controller.workhour;

import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import itx.core.web.BaseController;
import itx.core.web.WebRequest;
import itx.erp.helper.ErpConfig;
import itx.r2b.model.WorkHour;
import itx.r2b.service.WorkHourService;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.AuthorizationException;

public class WorkHourListController
extends BaseController {
    protected ErpConfig appConfig;
    protected WorkHourService workHourService;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public WorkHourService getWorkHourService() {
        return this.workHourService;
    }

    public void setWorkHourService(WorkHourService workHourService) {
        this.workHourService = workHourService;
    }

    @Override
    public void handleRequest(WebRequest webRequest) throws Exception {
        super.executeAction(webRequest);
    }

    public void indexAction(WebRequest req) throws SQLException, StreamWriteException, DatabindException, IOException, AuthorizationException {
        HashMap<String, Object> opts = new HashMap<String, Object>();
        if (req.hasParameter("pageNo")) {
            Integer pageNo = req.getParamInt("pageNo", 0);
            opts.put("start", pageNo * this.appConfig.getLimit());
        } else if (req.hasParameter("start")) {
            opts.put("start", req.getParamInt("start"));
        }
        opts.put("pageSize", this.appConfig.getLimit());
        opts.put("cid", req.getParameter("cid"));
        opts.put("uid", req.getParameter("uid"));
        opts.put("startDate", req.getParamDate("sd"));
        opts.put("endDate", req.getParamDate("ed"));
        opts.put("rs", req.getParameter("rs"));
        opts.put("q", req.getParameter("q"));
        if (req.hasParameter("lastEdited")) {
            opts.put("lastEdited", req.getParamInt("lastEdited"));
        }
        QueryResult<WorkHour> qrs = this.workHourService.searchHours(opts, req.getUserId());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", true);
        result.put("workhours", qrs.getObjects());
        result.put("start", qrs.getStart());
        result.put("pageSize", qrs.getPageSize());
        result.put("rowCount", qrs.getRowCount());
        req.renderJson(result);
    }

    public void searchAction(WebRequest req) {
    }
}

