/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.hooks;

import itx.erp.base.model.DbFile;
import itx.erp.base.model.UserPermission;
import itx.erp.base.model.UserPermissionCheck;
import itx.erp.base.model.UserPermissionList;
import itx.erp.base.service.UserService;
import itx.r2b.RtobObjectContainer;
import itx.r2b.service.WorkOrderService;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jtbcore.event.EventMessage;
import jtbcore.event.MessageBus;
import jtbcore.event.MessageSubscriber;

public class FileAccessHook {
    public void register() {
        this.registerFileAccess();
        this.registerListInheritedPermissions();
        this.logDeletion();
    }

    public void registerFileAccess() {
        MessageBus.getInstance().subscribe(new MessageSubscriber(){

            @Override
            public void message(EventMessage msg) {
                if (!"UserPermissionsService.checkAccess".equals(msg.getMessage())) {
                    return;
                }
                UserPermissionCheck upc = (UserPermissionCheck)msg.getProp("value");
                if (!"file".equals(upc.refObject)) {
                    return;
                }
                String sql = "select count(*) from rtob__work_order_file f join base__user_permission up on (up.ref_object = 'work_order' and up.ref_id = f.work_order_id) where up.user_id = " + String.valueOf(upc.user.getUserId()) + " and f.db_file_id = " + String.valueOf(upc.refId);
                try {
                    Integer v = (Integer)RtobObjectContainer.getInstance().getSqlConnection().queryValue(sql, Integer.class, new Object[0]);
                    if (v > 0) {
                        upc.writable();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void registerListInheritedPermissions() {
        MessageBus.getInstance().subscribe(new MessageSubscriber(){

            @Override
            public void message(EventMessage msg) {
                if (!"UserPermissionService.getPermissions".equals(msg.getMessage())) {
                    return;
                }
                UserPermissionList upl = (UserPermissionList)msg.getProp("value");
                if (!"file".equals(upl.getRefObject())) {
                    return;
                }
                try {
                    UserService uservice = RtobObjectContainer.getInstance().getUserService();
                    String sql2 = "select up.*, u.username, ug.group_name, wo.work_order_id, wo.description work_order_description, up.access_method from rtob__work_order_file wof join rtob__work_order wo on (wo.work_order_id = wof.work_order_id) join base__user_permission up on (wo.work_order_id = up.ref_id and up.ref_object='work_order') left join base__user u on (up.user_id = u.user_id) left join base__user_group ug on (up.group_id = ug.user_group_id) where db_file_id = ?";
                    List recs = uservice.queryToList(UserPermission.class, sql2, upl.getRefId());
                    ArrayList<UserPermission> contractsInherited = new ArrayList<UserPermission>();
                    HashMap<CallSite, UserPermission> map = new HashMap<CallSite, UserPermission>();
                    int x = 0;
                    while (x < recs.size()) {
                        UserPermission up2 = (UserPermission)recs.get(x);
                        String woId = up2.getBaseStringMap().getProperty("work_order_id");
                        String woDescription = up2.getBaseStringMap().getProperty("work_order_description");
                        String woName = "WB" + woId + " " + woDescription;
                        String refKey = String.valueOf(up2.getUserId()) + "-" + String.valueOf(up2.getGroupId());
                        if (map.containsKey(refKey)) {
                            Object pn = up2.getBaseStringMap().getProperty("permission_note");
                            pn = (String)pn + " & " + woName;
                            up2.getBaseStringMap().setProperty("permission_note", (String)pn);
                        } else {
                            up2.getBaseStringMap().setProperty("permission_note", woName);
                            map.put((CallSite)((Object)refKey), up2);
                            contractsInherited.add(up2);
                        }
                        ++x;
                    }
                    x = 0;
                    while (x < contractsInherited.size()) {
                        String n = ((UserPermission)contractsInherited.get(x)).getPermissionNote();
                        if (n.length() > 0) {
                            ((UserPermission)contractsInherited.get(x)).setPermissionNote("Contract(en): " + n);
                        }
                        ++x;
                    }
                    upl.getInheritedPermissions().addAll(contractsInherited);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public void logDeletion() {
        MessageBus.getInstance().subscribe(new MessageSubscriber(){

            @Override
            public void message(EventMessage msg) {
                if (!"FileService.deleteFile".equals(msg.getMessage())) {
                    return;
                }
                DbFile f = (DbFile)msg.getProp("value");
                try {
                    WorkOrderService w = (WorkOrderService)RtobObjectContainer.getInstance().getBean("workOrderService");
                    Integer userId = null;
                    if (msg.getProp("userId") instanceof Integer) {
                        userId = (Integer)msg.getProp("userId");
                    }
                    w.logFileDeletion(f, userId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

