/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.model.validator;

import itx.r2b.model.WorkHour;
import jtbcore.model.validator.BaseValidator;
import jtbcore.model.validator.ValidatorFunction;
import jtbcore.model.validator.ValidatorResult;

public class WorkHourValidator
extends BaseValidator<WorkHour> {
    public WorkHourValidator() {
        this.addValidator("startTime", new ValidatorFunction<WorkHour>(){

            @Override
            public ValidatorResult validate(WorkHour wh) {
                if (!"from_to".equals(wh.getTimingType())) {
                    return null;
                }
                if (wh.getStartTime() == null && wh.getEndTime() != null) {
                    return new ValidatorResult(false, "No start time");
                }
                if (wh.getEndTime() == null) {
                    return null;
                }
                if (wh.getStartTime() != null && wh.getEndTime() != null) {
                    long t1 = wh.getStartTime().getTime();
                    long t2 = wh.getEndTime().getTime();
                    if (t2 < t1) {
                        return new ValidatorResult(false, "End time before start time");
                    }
                }
                return null;
            }
        });
    }
}

