/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.relay;

import itx.erp.ErpObjectContainer;
import itx.r2b.RtobObjectContainer;
import itx.r2b.conf.RtobConf;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import jtbcore.exception.ContainerException;
import jtbcore.socket.RawHttpRequest;
import jtbcore.socket.SSLSocketFactory;
import jtbcore.util.AppLogger;
import jtbcore.util.SleepUtil;
import org.apache.commons.io.IOUtils;

public class RelayHandler
implements Runnable {
    protected ErpObjectContainer objectContainer = ErpObjectContainer.getInstance();
    protected String hostname = "www.report2base.nl";
    protected Integer port = 8099;
    protected String relayName = null;
    protected String relayPassword = null;
    protected Thread thread = null;
    protected boolean running = false;
    protected RelaySocket currentRelaySocket = null;

    public static boolean relayEnabled() throws ContainerException, SQLException {
        if (RtobObjectContainer.getInstance().isHosted()) {
            return false;
        }
        if (RtobObjectContainer.getInstance().getAppConfig().isDesktopMode()) {
            return true;
        }
        return RtobConf.getInstance().isActive();
    }

    public synchronized void start() {
        try {
            if (!RelayHandler.relayEnabled()) {
                this.stop();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            RtobConf rtobConf = RtobConf.getInstance();
            this.relayName = rtobConf.getRelayName();
            this.relayPassword = rtobConf.getPassword();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.running) {
            return;
        }
        this.running = true;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.thread.interrupt();
        try {
            if (this.currentRelaySocket != null) {
                this.currentRelaySocket.stop();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                this.currentRelaySocket = new RelaySocket();
                boolean bln = this.currentRelaySocket.run();
                if (bln) continue;
                Thread.sleep(500L);
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) break;
                if (ex instanceof ConnectException || ex instanceof SocketException || ex instanceof UnknownHostException || ex instanceof SocketTimeoutException) {
                    AppLogger.error("Error: " + ex.getClass().getSimpleName() + ": " + ex.getMessage());
                    SleepUtil.sleep(2000L, false);
                    continue;
                }
                SleepUtil.sleep(500L, false);
                ex.printStackTrace();
            }
        }
    }

    public class RelaySocket {
        protected boolean authenticated = false;
        protected InputStream is = null;
        protected OutputStream os = null;
        protected Thread thread = null;
        public Socket currentSocket = null;

        public void stop() throws IOException {
            this.currentSocket.close();
        }

        public boolean run() throws Exception {
            this.currentSocket = SSLSocketFactory.createConnection(RelayHandler.this.hostname, RelayHandler.this.port);
            this.currentSocket.setSoTimeout(60000);
            this.is = this.currentSocket.getInputStream();
            this.os = this.currentSocket.getOutputStream();
            String l = null;
            while ((l = this.readLine()) != null) {
                if (l.startsWith("HELLO")) {
                    this.writeLine("AUTH " + RelayHandler.this.relayName + ":" + RelayHandler.this.relayPassword);
                }
                if (l.startsWith("AUTHOK")) {
                    this.authenticated = true;
                    AppLogger.log("AUTHOK");
                }
                if (l.startsWith("ERROR")) {
                    AppLogger.log("Error, RelayHandler: " + l);
                    break;
                }
                if (l.startsWith("PING")) {
                    AppLogger.log("PONG");
                    this.writeLine("PONG");
                }
                if (!l.startsWith("START REQUEST")) continue;
                this.writeLine("READY4RESPONSE");
                AppLogger.log("START REQUEST - R4R!");
                Socket mysocket = this.currentSocket;
                this.thread = new Thread(() -> {
                    try {
                        this.handleRequest();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        mysocket.shutdownInput();
                        mysocket.shutdownOutput();
                        mysocket.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
                this.thread.start();
                return true;
            }
            AppLogger.log("Relay Disconnected");
            this.os.close();
            this.is.close();
            this.currentSocket.close();
            return false;
        }

        public void handleRequest() throws Exception {
            byte[] request = IOUtils.toByteArray((InputStream)this.is);
            RawHttpRequest r = new RawHttpRequest("127.0.0.1", RelayHandler.this.objectContainer.getAppConfig().getServerPort());
            byte[] buf = r.request2bytes(request);
            this.os.write(buf);
            this.os.flush();
        }

        public String readLine() throws IOException, InterruptedException {
            int r;
            byte[] buf = new byte[2048];
            int p = 0;
            do {
                if ((r = this.is.read()) < 0) {
                    return null;
                }
                buf[p] = (byte)r;
            } while (r != 10 && ++p < 2000);
            return new String(buf, 0, p);
        }

        public void writeLine(String l) throws IOException {
            if (!((String)l).endsWith("\n")) {
                l = (String)l + "\n";
            }
            this.os.write(((String)l).getBytes());
            this.os.flush();
        }
    }
}

