/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.reports;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jtbcore.db.common.SqlConnection;
import jtbcore.exception.InvalidArgument;
import jtbcore.model.BaseStringMap;
import jtbcore.util.DateUtil;
import jtbcore.util.NumberUtil;
import jtbcore.util.StringUtil;

public class WorkHourReportV1 {
    protected SqlConnection connection;
    protected Integer recordLimit = 100000;
    protected Integer customerId;
    protected Date startDate;
    protected Date endDate;
    protected String widgetType;
    protected Map<Integer, BaseStringMap> cacheCustomer = new HashMap<Integer, BaseStringMap>();
    protected Map<Integer, BaseStringMap> cacheWorkOrder = new HashMap<Integer, BaseStringMap>();
    protected List<Map<String, Object>> rlines;
    protected List<String> reportStatus = new ArrayList<String>();

    public SqlConnection getConnection() {
        return this.connection;
    }

    public void setConnection(SqlConnection connection) {
        this.connection = connection;
    }

    public Integer getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(Integer customerId) {
        this.customerId = customerId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public void addReportStatus(String s) throws InvalidArgument {
        if (!("open".equals(s) || "inprogress".equals(s) || "cancelled".equals(s) || "processed".equals(s))) {
            throw new InvalidArgument("Invalid report status: " + s);
        }
        this.reportStatus.add(s);
    }

    public String getWidgetType() {
        return this.widgetType;
    }

    public void setWidgetType(String widgetType) {
        this.widgetType = widgetType;
    }

    public List<BaseStringMap> getRecords() throws SQLException {
        ArrayList<Object> where = new ArrayList<Object>();
        ArrayList<Object> params = new ArrayList<Object>();
        Object sql = "select * from ( \t\tselect ww.widget_type, wo.customer_id, wo.work_order_id, ww.work_widget_id ref_id, ifnull(wo.order_date, wo.created) entry_date, rs1.status \t\tfrom rtob__work_order wo \t\tjoin rtob__work_widget ww on (wo.work_order_id = ww.work_order_id) \t\tleft join rtob__report_record_status rs1 on (rs1.ref_id = ww.work_widget_id and rs1.ref_table='work_widget') \t\twhere ww.widget_type IN ('SFHourWidget', 'SFHourLabelWidget', 'SFMoneyWidget', 'SFMoneyLabelWidget', 'SFNumberWidget', 'SFNumberLabelWidget') \t\tunion \t\tselect 'WorkHour', wh.customer_id, null, wh.work_hour_id ref_id, ifnull(start_time, created) entry_date, rs2.status \t\tfrom rtob__work_hour wh \t\tleft join rtob__report_record_status rs2 on (rs2.ref_id = wh.work_hour_id and rs2.ref_table='work_hour') ) x ";
        if (this.customerId != null) {
            where.add("x.customer_id = ?");
            params.add(this.customerId);
        }
        if (this.startDate != null) {
            where.add("x.entry_date >= ?");
            params.add(DateUtil.date2string(this.startDate) + " 00:00:00");
        }
        if (this.endDate != null) {
            where.add("x.entry_date <= ?");
            params.add(DateUtil.date2string(this.endDate) + " 23:59:59");
        }
        if (this.reportStatus.size() > 0) {
            String strIn = "('" + StringUtil.join("', '", this.reportStatus) + "')";
            where.add("ifnull(x.status, 'open') IN " + strIn);
        }
        if (this.widgetType != null) {
            if ("hour".equals(this.widgetType)) {
                where.add("x.widget_type IN ('SFHourWidget', 'SFHourLabelWidget', 'WorkHour')");
            } else if ("number".equals(this.widgetType)) {
                where.add("x.widget_type IN ('SFNumberWidget', 'SFNumberLabelWidget')");
            } else if ("amount".equals(this.widgetType)) {
                where.add("x.widget_type IN ('SFMoneyWidget', 'SFMoneyLabelWidget')");
            }
        }
        if (where.size() > 0) {
            sql = (String)sql + " where (" + StringUtil.join(") AND (", where) + ") ";
        }
        sql = (String)sql + " order by x.entry_date asc";
        List<BaseStringMap> recs = this.connection.queryBsmListLimit(this.recordLimit, (String)sql, params.toArray());
        return recs;
    }

    public List<Map<String, Object>> buildReport() throws SQLException {
        ArrayList<Map<String, Object>> rlines = new ArrayList<Map<String, Object>>();
        List<BaseStringMap> recs = this.getRecords();
        for (BaseStringMap rec : recs) {
            BaseStringMap bsmCustomer;
            HashMap<String, Object> rline = new HashMap<String, Object>();
            String widgetType = rec.getProperty("widget_type");
            rline.put("widget_type", widgetType);
            Integer customerId = rec.getPropertyInt("customer_id");
            rline.put("customer_id", customerId);
            rline.put("customer_name", null);
            if (customerId != null && (bsmCustomer = this.getCustomer(customerId)) != null) {
                rline.put("customer_name", bsmCustomer.getProperty("customer_name"));
            }
            Integer refId = rec.getPropertyInt("ref_id");
            rline.put("ref_id", refId);
            rline.put("entry_date", rec.getPropertyDateTime("entry_date"));
            String status = rec.getProperty("status");
            if (status == null) {
                status = "open";
            }
            rline.put("status", status);
            if ("SFHourWidget".equals(widgetType) || "SFHourLabelWidget".equals(widgetType)) {
                recWorkWidget = this.getWorkWidget(refId);
                lbl = recWorkWidget.getProperty("widget_label");
                v1 = recWorkWidget.getPropertyDouble("widget_value1");
                rline.put("work_order_id", rec.getPropertyInt("work_order_id"));
                rline.put("description", lbl);
                rline.put("duration", v1);
            } else if ("SFMoneyWidget".equals(widgetType) || "SFMoneyLabelWidget".equals(widgetType)) {
                recWorkWidget = this.getWorkWidget(refId);
                lbl = recWorkWidget.getProperty("widget_label");
                v1 = NumberUtil.tryCurrencyToDouble(recWorkWidget.getProperty("widget_value1"));
                rline.put("work_order_id", rec.getPropertyInt("work_order_id"));
                rline.put("description", lbl);
                rline.put("price", v1);
            } else if ("SFNumberWidget".equals(widgetType) || "SFNumberLabelWidget".equals(widgetType)) {
                recWorkWidget = this.getWorkWidget(refId);
                lbl = recWorkWidget.getProperty("widget_label");
                v1 = NumberUtil.tryCurrencyToDouble(recWorkWidget.getProperty("widget_value1"));
                rline.put("work_order_id", rec.getPropertyInt("work_order_id"));
                rline.put("description", lbl);
                rline.put("number", v1);
            } else if ("WorkHour".equals(widgetType)) {
                recWorkWidget = this.getWorkHour(refId);
                lbl = recWorkWidget.getProperty("short_description");
                String timingType = recWorkWidget.getProperty("timing_type");
                if ("from_to".equals(timingType)) {
                    Date start = recWorkWidget.getPropertyDateTime("start_time");
                    Date end = recWorkWidget.getPropertyDateTime("end_time");
                    rline.put("start_time", start);
                    rline.put("end_time", end);
                    if (start != null && end != null) {
                        Integer minsBetween = DateUtil.minsBetween(start, end);
                        Double dur = NumberUtil.roundPrice((double)minsBetween.intValue() / 60.0);
                        rline.put("duration", dur);
                    }
                } else if ("duration".equals(timingType)) {
                    Double dur = recWorkWidget.getPropertyDouble("duration");
                    rline.put("duration", dur);
                } else {
                    rline.put("duration", null);
                }
                rline.put("description", lbl);
            }
            rlines.add(rline);
        }
        this.rlines = rlines;
        return rlines;
    }

    public Double getTotalPrice() {
        Double p = 0.0;
        for (Map<String, Object> r : this.rlines) {
            Double p2;
            if (!r.containsKey("price") || (p2 = (Double)r.get("price")) == null) continue;
            p = p + p2;
        }
        return p;
    }

    public Double getTotalDuration() {
        Double d = 0.0;
        for (Map<String, Object> r : this.rlines) {
            Double d2;
            if (!r.containsKey("duration") || (d2 = (Double)r.get("duration")) == null) continue;
            d = d + d2;
        }
        return d;
    }

    public Double getTotalNumbers() {
        Double d = 0.0;
        for (Map<String, Object> r : this.rlines) {
            Double d2;
            if (!r.containsKey("number") || (d2 = (Double)r.get("number")) == null) continue;
            d = d + d2;
        }
        return d;
    }

    public BaseStringMap getWorkOrder(Integer workOrderId) throws SQLException {
        if (!this.cacheWorkOrder.containsKey(workOrderId)) {
            this.cacheWorkOrder.clear();
            String sql = "select * from rtob__work_order where work_order_id = ? ";
            BaseStringMap r = this.connection.queryBsm(sql, workOrderId);
            this.cacheWorkOrder.put(workOrderId, r);
        }
        return this.cacheWorkOrder.get(workOrderId);
    }

    public BaseStringMap getWorkWidget(Integer workWidgetId) throws SQLException {
        String sql = "select work_widget_id, work_order_id, widget_label, widget_value1 from rtob__work_widget where work_widget_id = ? ";
        BaseStringMap r = this.connection.queryBsm(sql, workWidgetId);
        return r;
    }

    public BaseStringMap getWorkHour(Integer workHourId) throws SQLException {
        String sql = "SELECT *  FROM rtob__work_hour where work_hour_id = ?";
        BaseStringMap r = this.connection.queryBsm(sql, workHourId);
        return r;
    }

    public BaseStringMap getCustomer(Integer customerId) throws SQLException {
        if (!this.cacheCustomer.containsKey(customerId)) {
            BaseStringMap c = this.connection.queryBsm("select customer_name from customer__customer where customer_id = ?", customerId);
            this.cacheCustomer.put(customerId, c);
        }
        return this.cacheCustomer.get(customerId);
    }
}

