/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.service;

import itx.erp.base.model.User;
import itx.erp.base.model.WebSession;
import itx.erp.base.service.UserService;
import itx.erp.base.service.WebSessionService;
import itx.erp.helper.ErpConfig;
import itx.r2b.StartRtob;
import itx.r2b.conf.RtobConf;
import itx.r2b.model.AppAuthRequest;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.security.sasl.AuthenticationException;
import jtbcore.exception.InvalidArgument;
import jtbcore.exception.InvalidStateException;
import jtbcore.exception.JTBException;
import jtbcore.service.ServiceBase;
import jtbcore.util.CryptUtil;
import jtbcore.util.NumberUtil;

public class RelayService
extends ServiceBase {
    protected ErpConfig appConfig;
    protected UserService userService;
    protected WebSessionService webSessionService;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public WebSessionService getWebSessionService() {
        return this.webSessionService;
    }

    public void setWebSessionService(WebSessionService webSessionService) {
        this.webSessionService = webSessionService;
    }

    public boolean isConfigured() throws SQLException {
        Integer i = this.appConfig.getSettingInt("r2b_relay_configured", 0);
        return i != null && i == 1;
    }

    public void markConfigured() throws SQLException, IOException {
        this.appConfig.setSetting("r2b_relay_configured", 1);
        if (RtobConf.getInstance().isActive()) {
            StartRtob.startRelay();
        }
    }

    public void createAuthRequest(AppAuthRequest r) throws IOException, SQLException {
        r.setUuid(CryptUtil.randomHash());
        r.setStatus("open");
        super.getConnection().save("rtob__app_auth_request", "app_auth_request_id", r);
    }

    public AppAuthRequest readAppAuth(Integer appAuthRequestId) throws SQLException, JTBException {
        AppAuthRequest r = (AppAuthRequest)this.queryToObject(AppAuthRequest.class, "select * from rtob__app_auth_request where app_auth_request_id = ?", appAuthRequestId);
        return r;
    }

    public List<AppAuthRequest> readLastAuths(Integer no, Integer lastAuthReqId) throws SQLException, JTBException {
        if (no == null) {
            no = 100;
        }
        List l = this.queryToList(AppAuthRequest.class, "select aar.*, u.username from rtob__app_auth_request aar left join base__user u on (aar.user_id = u.user_id) " + (String)(lastAuthReqId != null ? " where aar.app_auth_request_id > " + String.valueOf(lastAuthReqId) + " " : "") + "order by aar.app_auth_request_id desc limit " + String.valueOf(no), new Object[0]);
        return l;
    }

    public void truncateRequests() throws SQLException {
        this.connection.query("delete from rtob__app_auth_request", new Object[0]);
    }

    public WebSession acceptRequest(Integer appAuthRequestId, Integer adminUserId, Integer selectedUserId) throws SQLException, IOException, JTBException {
        User adminUser = this.userService.readUser(adminUserId);
        String log = "accepted by " + adminUser.getUsername();
        AppAuthRequest aar = this.readAppAuth(appAuthRequestId);
        User clientuser = this.userService.readUser(selectedUserId);
        WebSession s = this.webSessionService.createSession(clientuser, 2678400);
        aar.setStatus("accepted");
        aar.setWebSessionId(s.getWebSessionId());
        aar.setUserId(selectedUserId);
        aar.setLogInfo(log);
        this.connection.save("rtob__app_auth_request", "app_auth_request_id", aar);
        return s;
    }

    public void rejectRequest(Integer appAuthRequestId, Integer adminUserId) throws SQLException {
        Object log = "rejected";
        if (adminUserId != null) {
            log = "rejected by " + this.userService.getUsername(adminUserId);
        }
        this.connection.query("update rtob__app_auth_request set status = ?, log_info = ? where app_auth_request_id = ?", "rejected", log, appAuthRequestId);
    }

    public WebSession doAppAuthRequest(String app_auth_request_uid) throws SQLException, JTBException, AuthenticationException {
        if (app_auth_request_uid == null) {
            throw new InvalidArgument("No uid set");
        }
        int r = app_auth_request_uid.indexOf(46);
        if (r == -1) {
            throw new InvalidArgument("Invalid uid");
        }
        Integer reqid = NumberUtil.tryParseInt(app_auth_request_uid.substring(0, r));
        if (reqid == null) {
            throw new InvalidArgument("Malformed uid");
        }
        AppAuthRequest authreq = this.readAppAuth(reqid);
        if (authreq == null) {
            throw new AuthenticationException("Request not found, try again");
        }
        if (!authreq.getUuid().equals(app_auth_request_uid.substring(r + 1))) {
            throw new AuthenticationException("Invalid code");
        }
        if ("open".equals(authreq.getStatus())) {
            return null;
        }
        if ("used".equals(authreq.getStatus())) {
            throw new InvalidStateException("Request already used by other session");
        }
        if ("rejected".equals(authreq.getStatus())) {
            throw new AuthenticationException("Request rejected");
        }
        if ("accepted".equals(authreq.getStatus())) {
            WebSession s = this.webSessionService.readSessionById(authreq.getWebSessionId());
            this.connection.query("update rtob__app_auth_request set status = ? where app_auth_request_id = ?", "used", authreq.getAppAuthRequestId());
            return s;
        }
        throw new InvalidStateException("Unknown error occured");
    }
}

