/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.service;

import itx.r2b.model.SimpleForm;
import itx.r2b.model.SimpleFormWidget;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jtbcore.db.common.QueryBuilder;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.JTBException;
import jtbcore.exception.ObjectNotFoundException;
import jtbcore.model.BaseStringMap;
import jtbcore.service.ServiceBase;
import jtbcore.util.MapUtil;

public class SimpleFormService
extends ServiceBase {
    public SimpleForm readForm(Integer formId) throws SQLException, JTBException {
        SimpleForm f = (SimpleForm)this.queryToObject(SimpleForm.class, "select * from form__simple_form where simple_form_id = ?", formId);
        if (f == null) {
            throw new ObjectNotFoundException("Form not found");
        }
        List l = this.queryToList(SimpleFormWidget.class, "select * from form__simple_form_widget where simple_form_id = ? order by sort", f.getSimpleFormId());
        f.setWidgets(l);
        return f;
    }

    public void deleteForm(Integer formId, Integer userId) throws SQLException {
        this.connection.query("delete from form__simple_form_widget where simple_form_id = ?", formId);
        this.connection.query("delete from form__simple_form where simple_form_id = ?", formId);
    }

    public void save(SimpleForm f) throws SQLException, JTBException, IOException {
        SimpleForm old = null;
        if (f.getSimpleFormId() != null) {
            old = this.readForm(f.getSimpleFormId());
        }
        if (f.getSort() == null) {
            Integer newSort = (Integer)this.queryValue(Integer.class, "select max(sort) from form__simple_form where sort is not null", new Object[0]);
            if (newSort == null) {
                newSort = 1;
            }
            f.setSort(newSort);
        }
        this.connection.save("form__simple_form", "simple_form_id", f);
        if (f.isDefaultSelected() != null && f.isDefaultSelected().booleanValue()) {
            this.connection.query("update form__simple_form set default_selected = false where simple_form_id <> ?", f.getSimpleFormId());
        }
        int x = 0;
        while (x < f.getWidgets().size()) {
            SimpleFormWidget w = f.getWidgets().get(x);
            if (old != null && x < old.getWidgets().size()) {
                Integer wid = old.getWidgets().get(x).getSimpleFormWidgetId();
                w.setSimpleFormWidgetId(wid);
            }
            w.setSimpleFormId(f.getSimpleFormId());
            w.setSort(x);
            this.connection.save("form__simple_form_widget", "simple_form_widget_id", w);
            ++x;
        }
        if (old != null) {
            while (x < old.getWidgets().size()) {
                Integer wid = old.getWidgets().get(x).getSimpleFormWidgetId();
                this.connection.query("delete from form__simple_form_widget where simple_form_widget_id = ?", wid);
                ++x;
            }
        }
    }

    public QueryResult<SimpleForm> searchForms(Map<String, Object> opts) throws SQLException {
        if (opts == null) {
            opts = new HashMap<String, Object>();
        }
        QueryBuilder qb = new QueryBuilder(this.connection);
        qb.setTable("form__simple_form");
        qb.addSelectField("simple_form_id");
        qb.addSelectField("name");
        qb.addSelectField("default_selected");
        qb.addSelectField("active");
        qb.addSelectField("edited");
        qb.addSelectField("created");
        if (MapUtil.hasProperty(opts, "active") && MapUtil.boolValue(opts, "active")) {
            qb.addWhere("form__simple_form.active = true", new Object[0]);
        } else if (MapUtil.hasProperty(opts, "active") && !MapUtil.boolValue(opts, "active")) {
            qb.addWhere("form__simple_form.active = false", new Object[0]);
        }
        if (MapUtil.hasProperty(opts, "name")) {
            qb.addWhere("form__simple_form.name like ?", "%" + String.valueOf(opts.get("name")) + "%");
        }
        if (MapUtil.hasProperty(opts, "q")) {
            qb.addWhere("form__simple_form.name like ?", "%" + String.valueOf(opts.get("q")) + "%");
        }
        qb.addWhere("form__simple_form.type = 'master'", new Object[0]);
        qb.setRawOrderBy("form__simple_form.sort, form__simple_form.simple_form_id");
        ResultSet rs = qb.queryResultSet();
        QueryResult<SimpleForm> qr = new QueryResult<SimpleForm>();
        qr.fill(opts, SimpleForm.class, rs);
        rs.close();
        return qr;
    }

    public void updateSortForms(List<Integer> simpleFormIds) throws SQLException {
        int x = 0;
        while (x < simpleFormIds.size()) {
            Integer i = simpleFormIds.get(x);
            if (i != null) {
                this.connection.query("update form__simple_form set sort = ? where simple_form_id = ?", x + 1, i);
            }
            ++x;
        }
    }

    public List<SimpleForm> readActive() throws SQLException, JTBException {
        List<BaseStringMap> recs = this.connection.queryBsmList("select simple_form_id from form__simple_form where active = true and type='master' order by sort", new Object[0]);
        ArrayList<SimpleForm> forms = new ArrayList<SimpleForm>();
        for (BaseStringMap rec : recs) {
            Integer id = rec.getPropertyInt("simple_form_id");
            SimpleForm f = this.readForm(id);
            if (f.getWidgets().size() == 0) continue;
            forms.add(f);
        }
        return forms;
    }

    public SimpleForm readDefaultSelected() throws SQLException, JTBException {
        Integer sfid = (Integer)this.connection.queryValue("select simple_form_id from form__simple_form where active = true and default_selected = true", Integer.class, new Object[0]);
        if (sfid == null) {
            return null;
        }
        return this.readForm(sfid);
    }
}

