/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.service;

import itx.erp.base.model.Activity;
import itx.erp.base.model.User;
import itx.erp.base.model.UserGroup;
import itx.erp.base.model.UserPermission;
import itx.erp.base.service.ErpServiceBase;
import itx.erp.base.service.UserPermissionService;
import itx.erp.base.service.UserService;
import itx.erp.customer.service.CustomerService;
import itx.r2b.model.WorkFeedback;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jtbcore.db.common.QueryBuilder;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.AuthorizationException;
import jtbcore.exception.JTBException;
import jtbcore.exception.ObjectNotFoundException;
import jtbcore.util.DateUtil;
import jtbcore.util.NumberUtil;
import jtbcore.util.StringUtil;

public class WorkFeedbackService
extends ErpServiceBase {
    final String[] feedbackLogFields = new String[]{"status", "feedbackType", "deadline", "customerName", "shortDescription", "longDescription"};
    protected CustomerService customerService;
    protected UserPermissionService userPermissionService;
    protected UserService userService;

    public CustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    public UserPermissionService getUserPermissionService() {
        return this.userPermissionService;
    }

    public void setUserPermissionService(UserPermissionService userPermissionService) {
        this.userPermissionService = userPermissionService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public WorkFeedback readFeedback(Integer workFeedbackId, Integer reqUserId) throws SQLException, JTBException {
        User reqUser = this.userService.readUser(reqUserId);
        if (!reqUser.isAdmin()) {
            String accessMethod = reqUser.getAccessMethod("up.rtob_work_feedback");
            if (accessMethod.equals("none")) {
                throw new AuthorizationException("No access to feedback");
            }
            if (!accessMethod.equals("full")) {
                this.userPermissionService.checkAccess(reqUser, "work_feedback", workFeedbackId);
            }
        }
        String sql = "select f.*, c.customer_name from rtob__work_feedback f left join customer__customer c on (f.customer_id = c.customer_id) left join base__user u on (u.user_id = f.user_id) where f.work_feedback_id = ? ";
        WorkFeedback f = (WorkFeedback)this.queryToObject(WorkFeedback.class, sql, workFeedbackId);
        if (f == null) {
            throw new ObjectNotFoundException("WorkHour not found: " + String.valueOf(workFeedbackId));
        }
        if (f.getUserId() != null) {
            f.getBaseStringMap().setProperty("username", this.userService.getUsername(f.getUserId()));
        }
        List<UserPermission> perms = this.userPermissionService.readByRef("work_feedback", f.getWorkFeedbackId());
        f.setPermissions(perms);
        return f;
    }

    public void save(WorkFeedback f, Integer userId) throws IOException, SQLException, JTBException {
        WorkFeedback old = null;
        if (f.getWorkFeedbackId() != null) {
            old = this.readFeedback(f.getWorkFeedbackId(), userId);
        }
        this.connection.save("rtob__work_feedback", "work_feedback_id", f);
        this.userPermissionService.savePermissions("work_feedback", f.getWorkFeedbackId(), f.getPermissions());
        boolean isNew = old == null;
        Activity a = new Activity();
        a.setUserId(userId);
        String customerName = this.customerService.getCustomerName(f.getCustomerId());
        if (isNew) {
            a.setShortDescription("Feedback created, " + customerName + " - " + f.getShortDescription());
            a.setCode("work-feedback-created");
            a.logNew(f, this.feedbackLogFields);
        } else {
            a.setShortDescription("Feedback changed, " + customerName + " - " + f.getShortDescription());
            a.setCode("work-feedback-updated");
            a.logChange(old, f, this.feedbackLogFields);
        }
        a.setRefObject(WorkFeedback.class.getName());
        a.setRefId(f.getWorkFeedbackId());
        a.setCustomerId(f.getCustomerId());
        this.saveActivity(a);
    }

    public void deleteFeedback(Integer workFeedbackId, Integer userId) throws SQLException, JTBException, IOException {
        WorkFeedback old = this.readFeedback(workFeedbackId, userId);
        if (old == null) {
            throw new ObjectNotFoundException("Feedback not found, already deleted?");
        }
        this.connection.query("delete from rtob__work_feedback where work_feedback_id = ?", workFeedbackId);
        this.userPermissionService.deletePermissions("work_feedback", workFeedbackId);
        Activity a = new Activity();
        a.setUserId(userId);
        String customerName = this.customerService.getCustomerName(old.getCustomerId());
        a.setShortDescription("Feedback deleted, " + customerName + " - " + old.getShortDescription());
        a.setCode("work-feedback-deleted");
        a.logDelete(old, this.feedbackLogFields);
        a.setRefObject(WorkFeedback.class.getName());
        a.setRefId(old.getWorkFeedbackId());
        a.setCustomerId(old.getCustomerId());
        this.saveActivity(a);
    }

    public QueryResult<WorkFeedback> searchFeedback(Map<String, Object> opts, Integer reqUserId) throws SQLException, AuthorizationException {
        Integer int_q;
        String status;
        Integer customerId;
        if (opts == null) {
            opts = new HashMap<String, Object>();
        }
        QueryBuilder qb = new QueryBuilder(this.connection);
        qb.setTable("rtob__work_feedback");
        qb.addSelectField("rtob__work_feedback", "work_feedback_id");
        qb.addSelectField("rtob__work_feedback", "customer_id");
        qb.addSelectField("rtob__work_feedback", "user_id");
        qb.addSelectField("rtob__work_feedback", "deadline");
        qb.addSelectField("rtob__work_feedback", "feedback_type");
        qb.addSelectField("rtob__work_feedback", "short_description");
        qb.addSelectField("rtob__work_feedback", "status");
        qb.addSelectField("rtob__work_feedback", "edited");
        qb.addSelectField("rtob__work_feedback", "created");
        qb.addSelectField("customer__customer", "customer_name");
        qb.addSelectField("base__user", "username");
        qb.addLeftJoin("customer__customer", "customer__customer.customer_id = rtob__work_feedback.customer_id");
        qb.addLeftJoin("base__user", "base__user.user_id = rtob__work_feedback.user_id");
        if (opts.containsKey("cid") && (customerId = NumberUtil.tryParseInt(opts.get("cid"), null)) != null) {
            qb.addWhere("rtob__work_feedback.customer_id = ?", customerId);
        }
        if (opts.containsKey("uid")) {
            if (opts.get("uid") instanceof String) {
                String uid = (String)opts.get("uid");
                Integer userId = null;
                userId = uid.startsWith("user-") ? NumberUtil.tryParseInt(uid.substring(5)) : NumberUtil.tryParseInt(uid);
                if (userId != null) {
                    qb.addWhere("rtob__work_feedback.user_id = ?", userId);
                }
            }
            if (opts.get("uid") instanceof Integer) {
                qb.addWhere("rtob__work_feedback.user_id = ?", (Integer)opts.get("uid"));
            }
        }
        if (opts.get("startDate") instanceof Date) {
            qb.addWhere("deadline >= ?", DateUtil.date2string((Date)opts.get("startDate")) + " 00:00:00");
        }
        if (opts.get("endDate") instanceof Date) {
            qb.addWhere("deadline <= ?", DateUtil.date2string((Date)opts.get("endDate")) + " 23:59:59");
        }
        if (opts.get("status") instanceof String && (status = ((String)opts.get("status")).trim()).length() > 0) {
            qb.addWhere("rtob__work_feedback.status = ?", status);
        }
        ArrayList<String> selectedStatuses = new ArrayList<String>();
        if ("1".equals(opts.get("fsOpen"))) {
            selectedStatuses.add("open");
        }
        if ("1".equals(opts.get("fsInprogress"))) {
            selectedStatuses.add("inprogress");
        }
        if ("1".equals(opts.get("fsCancelled"))) {
            selectedStatuses.add("cancelled");
        }
        if ("1".equals(opts.get("fsDone"))) {
            selectedStatuses.add("done");
        }
        if (selectedStatuses.size() > 0) {
            String strIn = "('" + StringUtil.join("', '", selectedStatuses) + "') ";
            qb.addWhere("rtob__work_feedback.status IN " + strIn, new Object[0]);
        }
        if (opts.get("q") instanceof String) {
            String q = ((String)opts.get("q")).trim();
            if (q.startsWith("user-")) {
                Integer userId = NumberUtil.tryParseInt(q.substring(5));
                if (userId != null) {
                    qb.addWhere("rtob__work_feedback.user_id = ?", userId);
                }
            } else if (q.startsWith("customer-")) {
                Integer customerId2 = NumberUtil.tryParseInt(q.substring(9));
                if (customerId2 != null) {
                    qb.addWhere("rtob__work_feedback.customer_id = ?", customerId2);
                }
            } else if (q.length() > 0) {
                if (NumberUtil.isNumeric(q)) {
                    qb.addWhere("concat_ws(' ', rtob__work_feedback.short_description, customer__customer.customer_name, base__user.username, base__user.firstname, base__user.lastname, base__user.email) LIKE ? or rtob__work_feedback.work_feedback_id = ?", "%" + q + "%", q);
                } else {
                    qb.addWhere("concat_ws(' ', rtob__work_feedback.short_description, customer__customer.customer_name, base__user.username, base__user.firstname, base__user.lastname, base__user.email) LIKE ?", "%" + q + "%");
                }
            }
        }
        if (reqUserId != null) {
            User reqUser = this.userService.readUser(reqUserId);
            String accessMethod = reqUser.getAccessMethod("up.rtob_work_feedback");
            if (!reqUser.isAdmin() && "none".equals(accessMethod)) {
                throw new AuthorizationException("No access to work feedback");
            }
            if (!reqUser.isAdmin() && !"full".equals(accessMethod)) {
                Object groupFilter = "";
                if (reqUser.getGroup().size() > 0) {
                    for (UserGroup ug : reqUser.getGroup()) {
                        if (((String)groupFilter).length() != 0) {
                            groupFilter = (String)groupFilter + ", ";
                        }
                        groupFilter = (String)groupFilter + String.valueOf(ug.getUserGroupId());
                    }
                }
                String sqlPermissionFilter = "select ref_id from base__user_permission where (user_id = " + String.valueOf(reqUserId) + " " + (String)(((String)groupFilter).length() > 0 ? "or group_id in (" + (String)groupFilter + ")" : "") + ")  and ref_object='work_order'";
                qb.addWhere("rtob__work_feedback.work_feedback_id IN (" + sqlPermissionFilter + ") ", new Object[0]);
            }
        }
        if (opts.containsKey("lastEdited")) {
            Integer lastEdited = (Integer)opts.get("lastEdited");
            qb.setRawOrderBy("rtob__work_feedback.edited desc");
            qb.setLimit(lastEdited);
        } else {
            qb.setRawOrderBy("rtob__work_feedback.created desc");
        }
        Integer n = int_q = opts.get("q") != null ? NumberUtil.tryParseInt(opts.get("q").toString()) : null;
        if (int_q != null) {
            String orderBy = "rtob__work_feedback.work_feedback_id = " + String.valueOf(int_q) + " desc, " + qb.getRawOrderBy();
            qb.setRawOrderBy(orderBy);
        }
        ResultSet rs = qb.queryResultSet();
        QueryResult<WorkFeedback> qr = new QueryResult<WorkFeedback>();
        qr.fill(opts, WorkFeedback.class, rs);
        rs.close();
        return qr;
    }
}

