/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.service;

import itx.erp.base.model.Activity;
import itx.erp.base.model.User;
import itx.erp.base.model.UserGroup;
import itx.erp.base.model.UserPermission;
import itx.erp.base.service.ErpServiceBase;
import itx.erp.base.service.UserPermissionService;
import itx.erp.base.service.UserService;
import itx.erp.customer.service.CustomerService;
import itx.r2b.model.WorkHour;
import itx.r2b.service.ReportStatusService;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jtbcore.db.common.QueryBuilder;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.AuthorizationException;
import jtbcore.exception.JTBException;
import jtbcore.exception.ObjectNotFoundException;
import jtbcore.util.DateUtil;
import jtbcore.util.NumberUtil;

public class WorkHourService
extends ErpServiceBase {
    final String[] hourLogFields = new String[]{"reportStatus", "customerName", "shortDescription", "timingType", "startTime", "endTime", "duration", "longDescription"};
    protected CustomerService customerService;
    protected UserPermissionService userPermissionService;
    protected UserService userService;
    protected ReportStatusService reportStatusService;

    public CustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    public UserPermissionService getUserPermissionService() {
        return this.userPermissionService;
    }

    public void setUserPermissionService(UserPermissionService userPermissionService) {
        this.userPermissionService = userPermissionService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public ReportStatusService getReportStatusService() {
        return this.reportStatusService;
    }

    public void setReportStatusService(ReportStatusService reportStatusService) {
        this.reportStatusService = reportStatusService;
    }

    public WorkHour readHour(Integer workHourId, Integer loggedIn_userId) throws SQLException, JTBException {
        User reqUser = this.userService.readUser(loggedIn_userId);
        if (!reqUser.isAdmin()) {
            String accessMethod = reqUser.getAccessMethod("up.rtob_work_hours");
            if (accessMethod.equals("none")) {
                throw new AuthorizationException("No access to work hours");
            }
            if (!accessMethod.equals("full")) {
                this.userPermissionService.checkAccess(reqUser, "work_hour", workHourId);
            }
        }
        String sql = "select w.*, u.username, c.customer_name from rtob__work_hour w left join base__user u on (u.user_id = w.user_id) left join customer__customer c on (c.customer_id = w.customer_id) where w.work_hour_id = ?";
        WorkHour h = (WorkHour)this.queryToObject(WorkHour.class, sql, workHourId);
        if (h == null) {
            throw new ObjectNotFoundException("WorkHour: Object not found: " + String.valueOf(workHourId));
        }
        String reportStatus = this.reportStatusService.getRefStatus("work_hour", h.getWorkHourId());
        h.getBaseStringMap().setProperty("report_status", reportStatus);
        List<UserPermission> perms = this.userPermissionService.readByRef("work_hour", h.getWorkHourId());
        h.setPermissions(perms);
        return h;
    }

    public void save(WorkHour h, Integer userId) throws IOException, SQLException, JTBException {
        Object strShortDescCustomer;
        WorkHour old = null;
        if (h.getWorkHourId() != null) {
            old = this.readHour(h.getWorkHourId(), userId);
        }
        this.connection.save("rtob__work_hour", "work_hour_id", h);
        this.userPermissionService.savePermissions("work_hour", h.getWorkHourId(), h.getPermissions());
        boolean isNew = old == null;
        this.reportStatusService.setRefStatus("work_hour", h.getWorkHourId(), h.getReportStatus());
        Activity a = new Activity();
        a.setUserId(userId);
        String customerName = this.customerService.getCustomerName(h.getCustomerId());
        Object object = strShortDescCustomer = customerName != null ? customerName + " - " : "";
        if (isNew) {
            a.setShortDescription("Hour created, " + (String)strShortDescCustomer + h.getShortDescription());
            a.setCode("work-hour-created");
            a.logNew(h, this.hourLogFields);
        } else {
            a.setShortDescription("Hour changed, " + (String)strShortDescCustomer + h.getShortDescription());
            a.setCode("work-hour-updated");
            a.logChange(old, h, this.hourLogFields);
        }
        a.setRefObject(WorkHour.class.getName());
        a.setRefId(h.getWorkHourId());
        a.setCustomerId(h.getCustomerId());
        this.saveActivity(a);
    }

    public void deleteHour(Integer workHourId, Integer userId) throws SQLException, JTBException, IOException {
        WorkHour old = this.readHour(workHourId, userId);
        if (old == null) {
            throw new ObjectNotFoundException("Hour not found, already deleted?");
        }
        this.connection.query("delete from rtob__work_hour where work_hour_id = ?", workHourId);
        this.userPermissionService.deletePermissions("work_hour", workHourId);
        Activity a = new Activity();
        a.setUserId(userId);
        String customerName = this.customerService.getCustomerName(old.getCustomerId());
        a.setShortDescription("Hour deleted, " + customerName + " - " + old.getShortDescription());
        a.setCode("work-hour-deleted");
        a.logDelete(old, this.hourLogFields);
        a.setRefObject(WorkHour.class.getName());
        a.setRefId(old.getWorkHourId());
        a.setCustomerId(old.getCustomerId());
        this.saveActivity(a);
    }

    public QueryResult<WorkHour> searchHours(Map<String, Object> opts, Integer reqUserId) throws SQLException, AuthorizationException {
        Integer int_q;
        Integer customerId;
        if (opts == null) {
            opts = new HashMap<String, Object>();
        }
        QueryBuilder qb = new QueryBuilder(this.connection);
        qb.setTable("rtob__work_hour");
        qb.addSelectField("rtob__work_hour", "work_hour_id");
        qb.addSelectField("rtob__work_hour", "customer_id");
        qb.addSelectField("rtob__work_hour", "user_id");
        qb.addSelectField("rtob__work_hour", "short_description");
        qb.addSelectField("rtob__work_hour", "start_time");
        qb.addSelectField("rtob__work_hour", "end_time");
        qb.addSelectField("rtob__work_hour", "duration");
        qb.addSelectField("rtob__work_hour", "timing_type");
        qb.addSelectField("rtob__work_hour", "status");
        qb.addSelectField("rtob__work_hour", "edited");
        qb.addSelectField("rtob__work_hour", "created");
        qb.addSelectField("customer__customer", "customer_name");
        qb.addSelectField("base__user", "username");
        qb.addLeftJoin("customer__customer", "customer__customer.customer_id = rtob__work_hour.customer_id");
        qb.addLeftJoin("base__user", "base__user.user_id = rtob__work_hour.user_id");
        qb.addSelectField("rtob__report_record_status", "status", "report_status");
        qb.addLeftJoin("rtob__report_record_status", "rtob__report_record_status.ref_table='work_hour' and rtob__report_record_status.ref_id = rtob__work_hour.work_hour_id");
        if (opts.containsKey("cid") && (customerId = NumberUtil.tryParseInt(opts.get("cid"), null)) != null) {
            qb.addWhere("rtob__work_hour.customer_id = ?", customerId);
        }
        if (opts.containsKey("uid")) {
            if (opts.get("uid") instanceof String) {
                String uid = (String)opts.get("uid");
                Integer userId = null;
                userId = uid.startsWith("user-") ? NumberUtil.tryParseInt(uid.substring(5)) : NumberUtil.tryParseInt(uid);
                if (userId != null) {
                    qb.addWhere("rtob__work_hour.user_id = ?", userId);
                }
            }
            if (opts.get("uid") instanceof Integer) {
                qb.addWhere("rtob__work_hour.user_id = ?", (Integer)opts.get("uid"));
            }
        }
        if (opts.get("startDate") instanceof Date) {
            qb.addWhere("rtob__work_hour.start_time >= ?", DateUtil.date2string((Date)opts.get("startDate")) + " 00:00:00");
        }
        if (opts.get("endDate") instanceof Date) {
            qb.addWhere("rtob__work_hour.end_time <= ?", DateUtil.date2string((Date)opts.get("endDate")) + " 23:59:59");
        }
        String reportStatus = null;
        if (opts.get("rs") instanceof String) {
            reportStatus = ((String)opts.get("rs")).trim();
        } else if (opts.get("reportStatus") instanceof String) {
            reportStatus = ((String)opts.get("reportStatus")).trim();
        }
        if (reportStatus != null && reportStatus.length() > 0) {
            if ("open".equals(reportStatus)) {
                qb.addWhere("rtob__report_record_status.status is null OR rtob__report_record_status.status = ?", reportStatus);
            } else {
                qb.addWhere("rtob__report_record_status.status = ?", reportStatus);
            }
        }
        if (opts.get("q") instanceof String) {
            String q = ((String)opts.get("q")).trim();
            if (q.startsWith("user-")) {
                Integer userId = NumberUtil.tryParseInt(q.substring(5));
                if (userId != null) {
                    qb.addWhere("rtob__work_hour.user_id = ?", userId);
                }
            } else if (q.startsWith("customer-")) {
                Integer customerId2 = NumberUtil.tryParseInt(q.substring(9));
                if (customerId2 != null) {
                    qb.addWhere("rtob__work_hour.customer_id = ?", customerId2);
                }
            } else if (q.length() > 0) {
                if (NumberUtil.isNumeric(q)) {
                    qb.addWhere("concat_ws(' ', rtob__work_hour.short_description, customer__customer.customer_name, base__user.username, base__user.firstname, base__user.lastname, base__user.email) LIKE ? OR rtob__work_hour.work_hour_id = ?", "%" + q + "%", q);
                } else {
                    qb.addWhere("concat_ws(' ', rtob__work_hour.short_description, customer__customer.customer_name, base__user.username, base__user.firstname, base__user.lastname, base__user.email) LIKE ?", "%" + q + "%");
                }
            }
        }
        if (reqUserId != null) {
            User reqUser = this.userService.readUser(reqUserId);
            String accessMethod = reqUser.getAccessMethod("up.rtob_work_hours");
            if (!reqUser.isAdmin() && "none".equals(accessMethod)) {
                throw new AuthorizationException("No access to work hours");
            }
            if (!reqUser.isAdmin() && !"full".equals(accessMethod)) {
                Object groupFilter = "";
                if (reqUser.getGroup().size() > 0) {
                    for (UserGroup ug : reqUser.getGroup()) {
                        if (((String)groupFilter).length() != 0) {
                            groupFilter = (String)groupFilter + ", ";
                        }
                        groupFilter = (String)groupFilter + String.valueOf(ug.getUserGroupId());
                    }
                }
                String sqlPermissionFilter = "select ref_id from base__user_permission where (user_id = " + String.valueOf(reqUserId) + " " + (String)(((String)groupFilter).length() > 0 ? "or group_id in (" + (String)groupFilter + ")" : "") + ")  and ref_object='work_hour'";
                qb.addWhere("rtob__work_hour.work_hour_id IN (" + sqlPermissionFilter + ") ", new Object[0]);
            }
        }
        if (opts.containsKey("lastEdited")) {
            Integer lastEdited = (Integer)opts.get("lastEdited");
            qb.setRawOrderBy("rtob__work_hour.edited desc");
            qb.setLimit(lastEdited);
        } else {
            qb.setRawOrderBy("rtob__work_hour.created desc");
        }
        Integer n = int_q = opts.get("q") != null ? NumberUtil.tryParseInt(opts.get("q").toString()) : null;
        if (int_q != null) {
            String orderBy = "rtob__work_hour.work_hour_id = " + String.valueOf(int_q) + " desc, " + qb.getRawOrderBy();
            qb.setRawOrderBy(orderBy);
        }
        ResultSet rs = qb.queryResultSet();
        QueryResult<WorkHour> qr = new QueryResult<WorkHour>();
        qr.fill(opts, WorkHour.class, rs);
        rs.close();
        return qr;
    }
}

