/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.service;

import itx.erp.base.model.Activity;
import itx.erp.base.model.DbFile;
import itx.erp.base.model.User;
import itx.erp.base.model.UserGroup;
import itx.erp.base.model.UserPermission;
import itx.erp.base.service.ActivityService;
import itx.erp.base.service.ErpServiceBase;
import itx.erp.base.service.GroupService;
import itx.erp.base.service.UserPermissionService;
import itx.erp.base.service.UserService;
import itx.erp.customer.service.CustomerService;
import itx.r2b.model.WorkOrder;
import itx.r2b.model.WorkOrderFile;
import itx.r2b.model.WorkWidget;
import itx.r2b.service.ReportStatusService;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jtbcore.db.common.QueryBuilder;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.AuthorizationException;
import jtbcore.exception.InvalidArgument;
import jtbcore.exception.InvalidStateException;
import jtbcore.exception.JTBException;
import jtbcore.exception.ObjectNotFoundException;
import jtbcore.model.BaseStringMap;
import jtbcore.util.DateUtil;
import jtbcore.util.NumberUtil;

public class WorkOrderService
extends ErpServiceBase {
    final String[] workOrderLogFields = new String[]{"customerId", "userId", "description", "location", "orderDate", "status", "widgets.widgetType", "widgets.widgetLabel", "widgets.widgetValue1", "files.dbFileId", "usersGroups.description"};
    protected CustomerService customerService;
    protected UserService userService;
    protected GroupService groupService;
    protected UserPermissionService userPermissionService;
    protected ReportStatusService reportStatusService;
    protected ActivityService activityService;

    public CustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public GroupService getGroupService() {
        return this.groupService;
    }

    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    public UserPermissionService getUserPermissionService() {
        return this.userPermissionService;
    }

    public void setUserPermissionService(UserPermissionService userPermissionService) {
        this.userPermissionService = userPermissionService;
    }

    public ReportStatusService getReportStatusService() {
        return this.reportStatusService;
    }

    public void setReportStatusService(ReportStatusService reportStatusService) {
        this.reportStatusService = reportStatusService;
    }

    public ActivityService getActivityService() {
        return this.activityService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    public WorkOrder readWork(Integer workOrderId, Integer reqUserId) throws SQLException, JTBException {
        WorkOrder wo;
        User reqUser = this.userService.readUser(reqUserId);
        if (!reqUser.isAdmin()) {
            String accessMethod = reqUser.getAccessMethod("up.rtob_work_orders");
            if (accessMethod.equals("none")) {
                throw new AuthorizationException("No access to work orders");
            }
            if (!accessMethod.equals("full")) {
                this.userPermissionService.checkAccess(reqUser, "work_order", workOrderId);
            }
        }
        if ((wo = (WorkOrder)this.queryToObject(WorkOrder.class, "select * from rtob__work_order where work_order_id = ?", workOrderId)) == null) {
            throw new ObjectNotFoundException("WorkOrder not found (" + String.valueOf(workOrderId) + ")");
        }
        if (wo.getCustomerId() != null) {
            String customerName = this.customerService.getCustomerName(wo.getCustomerId());
            wo.getBaseStringMap().setProperty("customer_name", customerName);
        }
        if (wo.getUserId() != null) {
            String username = this.userService.getUsername(wo.getUserId());
            wo.getBaseStringMap().setProperty("username", username);
        }
        List widgets = this.queryToList(WorkWidget.class, "select * from rtob__work_widget where work_order_id = ?", wo.getWorkOrderId());
        int x = 0;
        while (x < widgets.size()) {
            WorkWidget ww = (WorkWidget)widgets.get(x);
            String reportStatus = this.reportStatusService.getRefStatus("work_widget", ww.getWorkWidgetId());
            ww.setReportStatus(reportStatus);
            ++x;
        }
        wo.setWidgets(widgets);
        List files = this.queryToList(WorkOrderFile.class, "select wof.*, f.path, f.size, f.original_filename, f.edited file_edited, f.created file_created from rtob__work_order_file wof join base__db_file f on (wof.db_file_id = f.db_file_id) where work_order_id = ?", wo.getWorkOrderId());
        wo.setFiles(files);
        List<UserPermission> perms = this.userPermissionService.readByRef("work_order", wo.getWorkOrderId());
        wo.setPermissions(perms);
        return wo;
    }

    public void save(WorkOrder wo, Integer userId) throws IOException, SQLException, JTBException {
        boolean isNew = true;
        WorkOrder old = null;
        if (wo.getWorkOrderId() != null) {
            old = this.readWork(wo.getWorkOrderId(), userId);
            isNew = false;
        }
        this.connection.save("rtob__work_order", "work_order_id", wo);
        int x = 0;
        while (x < wo.getWidgets().size()) {
            WorkWidget w = wo.getWidgets().get(x);
            if (old != null && x < old.getWidgets().size()) {
                Integer wid = old.getWidgets().get(x).getWorkWidgetId();
                w.setWorkWidgetId(wid);
            }
            w.setWorkOrderId(wo.getWorkOrderId());
            w.setSort(x);
            this.connection.save("rtob__work_widget", "work_widget_id", w);
            if (w.getReportStatus() != null && w.getReportStatus().length() > 0) {
                this.reportStatusService.setRefStatus("work_widget", w.getWorkWidgetId(), w.getReportStatus());
            }
            ++x;
        }
        if (old != null) {
            while (x < old.getWidgets().size()) {
                Integer wid = old.getWidgets().get(x).getWorkWidgetId();
                this.connection.query("delete from rtob__work_widget where work_widget_id = ?", wid);
                ++x;
            }
        }
        x = 0;
        while (x < wo.getFiles().size()) {
            WorkOrderFile wof = wo.getFiles().get(x);
            if (old != null && x < old.getFiles().size()) {
                Integer wof_id = old.getFiles().get(x).getWorkOrderFileId();
                wof.setWorkOrderFileId(wof_id);
            }
            wof.setWorkOrderId(wo.getWorkOrderId());
            wof.setSort(x);
            this.connection.save("rtob__work_order_file", "work_order_file_id", wof);
            ++x;
        }
        if (old != null) {
            while (x < old.getFiles().size()) {
                Integer waf_id = old.getFiles().get(x).getWorkOrderFileId();
                this.connection.query("delete from rtob__work_order_file where work_order_file_id = ?", waf_id);
                ++x;
            }
        }
        this.userPermissionService.savePermissions("work_order", wo.getWorkOrderId(), wo.getPermissions());
        this.logWorkOrder(wo, old, userId);
    }

    /*
     * Unable to fully structure code
     */
    public void saveApp(WorkOrder wa_changed, Integer userId) throws IOException, SQLException, JTBException {
        old = null;
        wo = null;
        if (wa_changed.getWorkOrderId() != null) {
            old = this.readWork(wa_changed.getWorkOrderId(), userId);
            wo = this.readWork(wa_changed.getWorkOrderId(), userId);
        }
        if (wo == null) {
            wo = wa_changed;
            wo.setUserId(userId);
        } else {
            wo.setCustomerId(wa_changed.getCustomerId());
            wo.setDescription(wa_changed.getDescription());
            wo.setLocationText(wa_changed.getLocationText());
            wo.setOrderDate(wa_changed.getOrderDate());
            wo.setStatus(wa_changed.getStatus());
        }
        this.connection.save("rtob__work_order", "work_order_id", wo);
        ww_ids = new ArrayList<Integer>();
        x = 0;
        while (x < wa_changed.getWidgets().size()) {
            w = wa_changed.getWidgets().get(x);
            prev = null;
            if (old != null && w.getWorkWidgetId() != null) {
                for (WorkWidget old_ww : old.getWidgets()) {
                    if (!old_ww.getWorkWidgetId().equals(w.getWorkWidgetId())) continue;
                    prev = old_ww;
                    break;
                }
            }
            if (prev == null) ** GOTO lbl37
            if (!"open".equals(prev.getReportStatus())) {
                ww_ids.add(prev.getWorkWidgetId());
                this.connection.query("update rtob__work_widget set sort = ? where work_widget_id = ?", new Object[]{x, prev.getWorkWidgetId()});
            } else {
                prev.setWidgetLabel(w.getWidgetLabel());
                prev.setWidgetValue1(w.getWidgetValue1());
                w = prev;
lbl37:
                // 2 sources

                w.setWorkOrderId(wo.getWorkOrderId());
                w.setSort(x);
                if (w.getWidgetType() != null) {
                    wwid = this.connection.save("rtob__work_widget", "work_widget_id", w);
                    ww_ids.add(wwid);
                }
            }
            ++x;
        }
        if (old != null) {
            y = 0;
            while (y < old.getWidgets().size()) {
                ww = old.getWidgets().get(y);
                if ("open".equals(ww.getReportStatus()) && ww_ids.indexOf(wid = ww.getWorkWidgetId()) == -1) {
                    this.connection.query("delete from rtob__work_widget where work_widget_id = ?", new Object[]{wid});
                }
                ++y;
            }
        }
        if (old == null) {
            ups = this.defaultPermissions(userId);
            this.userPermissionService.savePermissions("work_order", wo.getWorkOrderId(), ups);
        }
        this.logWorkOrder(wo, old, userId);
    }

    protected void logWorkOrder(WorkOrder wo, WorkOrder old, Integer userId) throws SQLException, JTBException, IOException {
        boolean isNew = old == null;
        Activity a = new Activity();
        a.setUserId(userId);
        String customerName = this.customerService.getCustomerName(wo.getCustomerId());
        if (isNew) {
            a.setShortDescription("Work order created, " + customerName + " - " + wo.getDescription());
            a.setCode("work-order-created");
            a.logNew(wo, this.workOrderLogFields);
        } else {
            a.setShortDescription("Work order changed, " + customerName + " - " + wo.getDescription());
            a.setCode("work-order-updated");
            a.logChange(old, wo, this.workOrderLogFields);
        }
        a.setRefObject(WorkOrder.class.getName());
        a.setRefId(wo.getWorkOrderId());
        a.setCustomerId(wo.getCustomerId());
        this.saveActivity(a);
    }

    public Integer linkFile(Integer workOrderId, Integer dbFileId) throws SQLException, IOException {
        Integer count = (Integer)this.connection.queryValue("select count(*) from rtob__work_order_file where work_order_id = ? and db_file_id = ?", Integer.class, workOrderId, dbFileId);
        if (count > 0) {
            return null;
        }
        Integer lastSort = (Integer)this.connection.queryValue("select max(sort) from rtob__work_order_file where work_order_id = ?", Integer.class, workOrderId);
        if (lastSort == null) {
            lastSort = 0;
        }
        WorkOrderFile wof = new WorkOrderFile();
        wof.setWorkOrderId(workOrderId);
        wof.setDbFileId(dbFileId);
        wof.setSort(lastSort + 1);
        Integer id = this.connection.save("rtob__work_order_file", "work_order_file_id", wof);
        return id;
    }

    public void deleteWork(Integer workOrderId, Integer loggedIn_userId) throws SQLException, JTBException, IOException {
        WorkOrder wo = this.readWork(workOrderId, loggedIn_userId);
        if (!"open".equals(wo.getStatus())) {
            throw new InvalidStateException("Unable to delete WorkOrder, status not set to 'open'");
        }
        this.connection.query("delete from rtob__work_order where work_order_id = ?", wo.getWorkOrderId());
        this.connection.query("delete from rtob__work_order_user_group where work_order_id = ?", wo.getWorkOrderId());
        this.connection.query("delete from rtob__work_order_file where work_order_id = ?", wo.getWorkOrderId());
        this.connection.query("delete from rtob__work_widget where work_order_id = ?", wo.getWorkOrderId());
        this.userPermissionService.deletePermissions("work_order", workOrderId);
        Activity a = new Activity();
        a.setUserId(loggedIn_userId);
        a.setShortDescription("Work Order deleted, " + wo.getDescription());
        a.setCode("work-order-deleted");
        a.logDelete(wo, this.workOrderLogFields);
        a.setRefObject(WorkOrder.class.getName());
        a.setRefId(wo.getWorkOrderId());
        a.setCustomerId(wo.getCustomerId());
        this.saveActivity(a);
    }

    public QueryResult<WorkOrder> searchWork(Map<String, Object> opts, Integer reqUserId) throws SQLException, AuthorizationException {
        Integer int_q;
        String status;
        Integer userId;
        Integer customerId;
        if (opts == null) {
            opts = new HashMap<String, Object>();
        }
        QueryBuilder qb = new QueryBuilder(this.connection);
        qb.setTable("rtob__work_order");
        qb.addSelectField("rtob__work_order", "work_order_id");
        qb.addSelectField("rtob__work_order", "description");
        qb.addSelectField("rtob__work_order", "customer_id");
        qb.addSelectField("rtob__work_order", "user_id");
        qb.addSelectField("rtob__work_order", "order_date");
        qb.addSelectField("rtob__work_order", "status");
        qb.addSelectField("rtob__work_order", "edited");
        qb.addSelectField("rtob__work_order", "created");
        qb.addSelectField("customer__customer", "customer_name");
        qb.addLeftJoin("customer__customer", "customer__customer.customer_id = rtob__work_order.customer_id");
        qb.addSelectField("base__user", "username");
        qb.addLeftJoin("base__user", "base__user.user_id = rtob__work_order.user_id");
        if (opts.containsKey("cid") && (customerId = NumberUtil.tryParseInt(opts.get("cid"), null)) != null) {
            qb.addWhere("rtob__work_order.customer_id = ?", customerId);
        }
        if (opts.containsKey("uid")) {
            if (opts.get("uid") instanceof String) {
                String uid = (String)opts.get("uid");
                userId = null;
                userId = uid.startsWith("user-") ? NumberUtil.tryParseInt(uid.substring(5)) : NumberUtil.tryParseInt(uid);
                if (userId != null) {
                    qb.addWhere("rtob__work_order.user_id = ?", userId);
                }
            }
            if (opts.get("uid") instanceof Integer) {
                qb.addWhere("rtob__work_order.user_id = ?", (Integer)opts.get("uid"));
            }
        }
        if (opts.get("startDate") instanceof Date) {
            qb.addWhere("order_date >= ?", DateUtil.date2string((Date)opts.get("startDate")) + " 00:00:00");
        }
        if (opts.get("endDate") instanceof Date) {
            qb.addWhere("order_date <= ?", DateUtil.date2string((Date)opts.get("endDate")) + " 23:59:59");
        }
        if (opts.get("status") instanceof String && (status = ((String)opts.get("status")).trim()).length() > 0) {
            qb.addWhere("rtob__work_order.status = ?", status);
        }
        if (opts.get("q") instanceof String) {
            String q = ((String)opts.get("q")).trim();
            if (q.startsWith("user-")) {
                userId = NumberUtil.tryParseInt(q.substring(5));
                if (userId != null) {
                    qb.addWhere("rtob__work_order.user_id = ?", userId);
                }
            } else if (q.startsWith("customer-")) {
                Integer customerId2 = NumberUtil.tryParseInt(q.substring(9));
                if (customerId2 != null) {
                    qb.addWhere("rtob__work_order.customer_id = ?", customerId2);
                }
            } else if (q.length() > 0) {
                if (NumberUtil.isNumeric(q)) {
                    qb.addWhere("concat_ws(' ', rtob__work_order.description, customer__customer.customer_name, base__user.username, base__user.firstname, base__user.lastname, base__user.email) LIKE ? OR rtob__work_order.work_order_id = ?", "%" + q + "%", q);
                } else {
                    qb.addWhere("concat_ws(' ', rtob__work_order.description, customer__customer.customer_name, base__user.username, base__user.firstname, base__user.lastname, base__user.email) LIKE ?", "%" + q + "%");
                }
            }
        }
        if (reqUserId != null) {
            User reqUser = this.userService.readUser(reqUserId);
            String accessMethod = reqUser.getAccessMethod("up.rtob_work_orders");
            if (!reqUser.isAdmin() && "none".equals(accessMethod)) {
                throw new AuthorizationException("No access to work orders");
            }
            if (!reqUser.isAdmin() && !"full".equals(accessMethod)) {
                Object groupFilter = "";
                if (reqUser.getGroup().size() > 0) {
                    for (UserGroup ug : reqUser.getGroup()) {
                        if (((String)groupFilter).length() != 0) {
                            groupFilter = (String)groupFilter + ", ";
                        }
                        groupFilter = (String)groupFilter + String.valueOf(ug.getUserGroupId());
                    }
                }
                String sqlPermissionFilter = "select ref_id from base__user_permission where (user_id = " + String.valueOf(reqUserId) + " " + (String)(((String)groupFilter).length() > 0 ? "or group_id in (" + (String)groupFilter + ")" : "") + ")  and ref_object='work_order'";
                qb.addWhere("rtob__work_order.work_order_id IN (" + sqlPermissionFilter + ") ", new Object[0]);
            }
        }
        if (opts.get("lastEdited") != null) {
            Integer lastEdited = (Integer)opts.get("lastEdited");
            qb.setRawOrderBy("rtob__work_order.edited desc");
            qb.setLimit(lastEdited);
        } else {
            qb.setRawOrderBy("rtob__work_order.edited desc");
        }
        Integer n = int_q = opts.get("q") != null ? NumberUtil.tryParseInt(opts.get("q").toString()) : null;
        if (int_q != null) {
            String orderBy = "rtob__work_order.work_order_id = " + String.valueOf(int_q) + " desc, " + qb.getRawOrderBy();
            qb.setRawOrderBy(orderBy);
        }
        ResultSet rs = qb.queryResultSet();
        QueryResult<WorkOrder> qr = new QueryResult<WorkOrder>();
        qr.fill(opts, WorkOrder.class, rs);
        rs.close();
        return qr;
    }

    public List<UserPermission> defaultPermissions(Integer userId) throws SQLException, JTBException {
        User user = this.userService.readUser(userId);
        ArrayList<UserPermission> ups = new ArrayList<UserPermission>();
        UserPermission up_user = new UserPermission();
        up_user.setAccessMethod("write");
        up_user.setUserId(userId);
        up_user.getBaseStringMap().setProperty("username", user.getUsername());
        ups.add(up_user);
        for (UserGroup ug : user.getGroup()) {
            UserPermission up_group = new UserPermission();
            up_group.setAccessMethod("write");
            up_group.setGroupId(ug.getUserGroupId());
            up_group.getBaseStringMap().setProperty("group_name", ug.getGroupName());
            ups.add(up_group);
        }
        List<UserGroup> ugs = this.groupService.readDefaultSelected();
        for (UserGroup ug : ugs) {
            if (user.getGroup().contains(ug)) continue;
            UserPermission up_group = new UserPermission();
            up_group.setAccessMethod("write");
            up_group.setGroupId(ug.getUserGroupId());
            up_group.getBaseStringMap().setProperty("group_name", ug.getGroupName());
            ups.add(up_group);
        }
        return ups;
    }

    public void logFileDeletion(DbFile f, Integer reqUserId) throws SQLException, JTBException, IOException {
        String sql = "select * from rtob__work_order_file where db_file_id = ?";
        List l = this.queryToList(WorkOrderFile.class, sql, f.getDbFileId());
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (WorkOrderFile wof : l) {
            if (ids.contains(wof.getWorkOrderId())) continue;
            Activity a = new Activity();
            a.setRefObject(WorkOrder.class.getName());
            a.setRefId(wof.getWorkOrderId());
            a.setShortDescription("File unlinked (deletion): " + f.getOriginalFilename());
            a.setCode("file-unlink");
            a.addValue("refDescription", f.getRefDescription(), (String)null);
            a.setUserId(reqUserId);
            this.saveActivity(a);
            ids.add(wof.getWorkOrderId());
            this.connection.query("delete from rtob__work_order_file where work_order_file_id = ?", wof.getWorkOrderFileId());
        }
    }

    protected void updateWorkOrderStatus(Integer workOrderId, String newStatus, Integer reqUserId) throws SQLException, JTBException, IOException {
        if (newStatus == null) {
            throw new InvalidArgument("newStatus can't be null");
        }
        WorkOrder wo = (WorkOrder)this.queryToObject(WorkOrder.class, "select * from rtob__work_order where work_order_id = ?", workOrderId);
        if (newStatus.equals(wo.getStatus())) {
            return;
        }
        this.connection.query("update rtob__work_order set status = ? where work_order_id = ?", newStatus, wo.getWorkOrderId());
        this.activityService.createActivityRef(reqUserId, WorkOrder.class.getName(), wo.getWorkOrderId(), "status-update", "Auto status update: " + wo.getStatus() + " => " + newStatus, null);
    }

    public void autoUpdateStatus(Integer workOrderId, Integer reqUserId) throws SQLException, JTBException, IOException {
        List<BaseStringMap> recs = this.connection.queryBsmList("select ww.work_widget_id, ww.widget_type, rs.status from rtob__work_widget ww left join rtob__report_record_status rs on (rs.ref_table='work_widget' and rs.ref_id = ww.work_widget_id) where ww.work_order_id = ?", workOrderId);
        int openCount = 0;
        int inprogressCount = 0;
        int cancelledCount = 0;
        int processedCount = 0;
        for (BaseStringMap rec : recs) {
            String wt = rec.getProperty("widget_type");
            if ("SFNoteWidget".equals(wt) || "SFCheckboxWidget".equals(wt)) continue;
            String rs = rec.getProperty("status");
            if ("open".equals(rs)) {
                ++openCount;
                continue;
            }
            if ("inprogress".equals(rs)) {
                ++inprogressCount;
                continue;
            }
            if ("cancelled".equals(rs)) {
                ++cancelledCount;
                continue;
            }
            if (!"processed".equals(rs)) continue;
            ++processedCount;
        }
        if (openCount == 0 && inprogressCount == 0 && cancelledCount == 0 && processedCount == 0) {
            return;
        }
        if (openCount != 0) {
            return;
        }
        if (inprogressCount > 0) {
            this.updateWorkOrderStatus(workOrderId, "inprogress", reqUserId);
        }
        if (inprogressCount == 0 && processedCount == 0 && cancelledCount > 0) {
            this.updateWorkOrderStatus(workOrderId, "cancelled", reqUserId);
        }
        if (inprogressCount == 0 && cancelledCount >= 0 && processedCount > 0) {
            this.updateWorkOrderStatus(workOrderId, "processed", reqUserId);
        }
    }
}

