/*
 * Decompiled with CFR 0.152.
 */
package itx.r2b.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import itx.core.web.WebRequest;
import itx.core.web.filter.RequestAuthFilter;
import itx.core.web.filter.RequestFilterList;
import itx.core.web.filter.RequestRouteFilter;
import itx.erp.ErpObjectContainer;
import itx.r2b.RtobObjectContainer;
import itx.r2b.hooks.BootstrapRtob;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import jtbcore.db.mysql.MysqlConnection;
import jtbcore.exception.ContainerException;
import jtbcore.exception.JTBException;

public class RtobRouter
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected ErpObjectContainer objectContainer = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        System.out.println("init servlet..");
        ErpObjectContainer.HOSTED = true;
        ErpObjectContainer.CONTEXT_PATH = config.getServletContext().getContextPath();
        RtobObjectContainer oc = RtobObjectContainer.getInstance();
        this.objectContainer = oc;
        String r = config.getServletContext().getRealPath(".");
        try {
            this.objectContainer.getAppConfig().setServletRoot(r);
        }
        catch (ContainerException e) {
            e.printStackTrace();
        }
        try {
            BootstrapRtob.startupHooks();
        }
        catch (ContainerException e) {
            e.printStackTrace();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            ((MysqlConnection)this.objectContainer.getSqlConnection()).ping();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        resp.setCharacterEncoding("UTF-8");
        resp.setHeader("Access-Control-Allow-Methods", "POST, GET");
        resp.setHeader("Access-Control-Allow-Origin", "*");
        resp.setHeader("Access-Control-Allow-Headers", "*");
        resp.setHeader("Access-Control-Expose-Headers", "*");
        resp.setHeader("Connection", "close");
        try {
            WebRequest webReq = new WebRequest(req, resp);
            RequestFilterList rfl = new RequestFilterList();
            rfl.addFilter(new RequestRouteFilter());
            rfl.addFilter(new RequestAuthFilter());
            rfl.execute(webReq);
            webReq.getController().handleRequest(webReq);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            HashMap<String, Object> err = new HashMap<String, Object>();
            err.put("error", true);
            err.put("success", false);
            if (ex.getCause() != null && ex.getCause() instanceof JTBException) {
                err.put("message", ex.getCause().getMessage());
            } else if (ex instanceof InvocationTargetException && ex.getCause() != null) {
                err.put("message", ex.getCause().getMessage());
            } else if (ex instanceof JTBException) {
                err.put("message", ex.getMessage());
            } else {
                err.put("message", ex.toString());
            }
            resp.setStatus(500);
            resp.setContentType("application/json");
            ObjectMapper om = new ObjectMapper();
            om.writeValue((OutputStream)resp.getOutputStream(), err);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Access-Control-Allow-Methods", "POST, GET");
        resp.setHeader("Access-Control-Allow-Origin", "*");
        resp.setHeader("Access-Control-Allow-Headers", "*");
        resp.setHeader("Access-Control-Expose-Headers", "*");
        resp.setHeader("Connection", "close");
    }
}

