/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.db.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jtbcore.db.parser.BaseTokenizer;
import jtbcore.db.sql.SqlColumn;

public class CreateSqlParser
extends BaseTokenizer {
    protected String tableName;
    protected List<SqlColumn> columns;

    public String getTableName() {
        return this.tableName;
    }

    public List<SqlColumn> getColumns() {
        return this.columns;
    }

    public SqlColumn getColumnByName(String name) {
        for (SqlColumn c : this.columns) {
            if (!name.equalsIgnoreCase(c.name)) continue;
            return c;
        }
        return null;
    }

    public void parseSql(String sql) throws IOException {
        this.parse(sql);
        this.removeWhiteTokens();
        this.columns = new ArrayList<SqlColumn>();
        int parCount = 0;
        String[] columnData = new String[40];
        int columnDataCount = 0;
        boolean inCreateStatement = false;
        int x = 1;
        while (x < this.tokens.size()) {
            String tprev = (String)this.tokens.get(x - 1);
            String tcur = (String)this.tokens.get(x);
            if ("(".equals(tcur) && ++parCount == 1) {
                inCreateStatement = true;
            } else {
                if (")".equals(tcur)) {
                    --parCount;
                }
                if (parCount == 0 && "create".equalsIgnoreCase(tprev) && "table".equalsIgnoreCase(tcur)) {
                    this.tableName = this.removeBackticks((String)this.tokens.get(x + 1));
                }
                if (parCount >= 1) {
                    columnData[columnDataCount++] = tcur;
                }
                if (columnDataCount > 0 && parCount == 1 && ",".equals(tcur) || parCount == 0 && ")".equals(tcur)) {
                    String pos1 = columnData[0];
                    if ("primary".equalsIgnoreCase(pos1)) {
                        colName = this.removeBackticks(columnData[3]);
                        for (SqlColumn c : this.columns) {
                            if (!colName.equals(c.name)) continue;
                            c.primaryKey = true;
                            break;
                        }
                    } else if (!"foreign".equalsIgnoreCase(pos1) && !"constraint".equalsIgnoreCase(pos1)) {
                        colName = this.removeBackticks(pos1);
                        Object dataType = "";
                        int dtpCount = 0;
                        int y = 1;
                        while (y < columnDataCount) {
                            if (y + 1 < columnDataCount && "(".equals(columnData[y + 1])) {
                                ++dtpCount;
                            }
                            if (")".equals(columnData[y])) {
                                --dtpCount;
                            }
                            dataType = (String)dataType + columnData[y];
                            if (dtpCount == 0) break;
                            ++y;
                        }
                        boolean autoIncrement = false;
                        int y2 = 1;
                        while (y2 < columnDataCount) {
                            if ("auto_increment".equalsIgnoreCase(columnData[y2])) {
                                autoIncrement = true;
                                break;
                            }
                            ++y2;
                        }
                        boolean primaryKey = false;
                        int y3 = 1;
                        while (y3 < columnDataCount - 1) {
                            if ("primary".equalsIgnoreCase(columnData[y3]) && "key".equalsIgnoreCase(columnData[y3 + 1])) {
                                primaryKey = true;
                                break;
                            }
                            ++y3;
                        }
                        SqlColumn col = new SqlColumn();
                        col.name = colName;
                        col.sqlDatatype = dataType;
                        col.autoincrement = autoIncrement;
                        col.primaryKey = primaryKey;
                        this.columns.add(col);
                    }
                    columnDataCount = 0;
                }
                if (parCount == 0 && inCreateStatement) break;
            }
            ++x;
        }
    }

    public static void main(String[] args) {
        String sql = "\t\t\t\tCREATE TABLE `contracts__contract`(\n  `contract_id` int NOT NULL AUTO_INCREMENT,\n  `contract_type_id` int DEFAULT NULL,\n  `company_id` int DEFAULT NULL,\n  `person_id` int DEFAULT NULL,\n  `file_id` int DEFAULT NULL,\n  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,\n  `start_date` date DEFAULT NULL,\n  `end_date` date DEFAULT NULL,\n  `time_notice` int DEFAULT NULL,\n  `time_notice_unit` enum('day','week','month','year') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,\n  `renew_period` int DEFAULT NULL,\n  `renew_unit` enum('day','week','month','year') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,\n  `status` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,\n  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,\n  `edited` datetime DEFAULT NULL,\n  `created` datetime DEFAULT NULL,\n  `auto_renew` tinyint(1) DEFAULT NULL,\n  `deleted` datetime DEFAULT NULL,\n  `parent_contract_id` int DEFAULT NULL,\n  `amount_text` varchar( 255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,\n  `renew_date_temp` date DEFAULT NULL,\n  `auto_renew_mail` tinyint(1) DEFAULT '1',\n  PRIMARY KEY (`contract_id`)\n) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci\n\n";
        try {
            CreateSqlParser p = new CreateSqlParser();
            p.parseSql(sql);
            for (SqlColumn c : p.getColumns()) {
                System.out.println(c.name + "\t" + c.sqlDatatype + "\t" + c.autoincrement);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

