/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.db.sqlite;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jtbcore.db.model.ColumnModel;
import jtbcore.db.model.DatabaseModel;
import jtbcore.db.model.IndexModel;
import jtbcore.db.model.TableModel;
import jtbcore.db.parser.CreateSqlParser;
import jtbcore.db.sql.SqlColumn;
import jtbcore.db.sql.SqlDatabase;
import jtbcore.db.sql.SqlTable;
import jtbcore.db.sqlite.SqlLiteConnection;
import jtbcore.model.BaseStringMap;
import jtbcore.util.AppLogger;
import jtbcore.util.StringUtil;

public class SqliteTableModelGenerator {
    protected DatabaseModel model;
    protected List<String> updateQueries;

    public SqliteTableModelGenerator() {
    }

    public SqliteTableModelGenerator(DatabaseModel model) {
        this.setModel(model);
    }

    public DatabaseModel getModel() {
        return this.model;
    }

    public void setModel(DatabaseModel model) {
        this.model = model;
    }

    public String generateCreateTable(String tableName) {
        TableModel tm = this.getModel().getTable(tableName);
        List<ColumnModel> cols = tm.getColumns();
        StringBuilder b = new StringBuilder();
        b.append("CREATE TABLE ");
        b.append("\"" + tm.getName() + "\"");
        b.append(" (\n");
        int cnt = 0;
        for (ColumnModel cm : cols) {
            String type = this.dbtype(cm.getType());
            b.append("    \"").append(cm.getName()).append("\" ").append(type);
            if (cm.isPrimaryKey()) {
                b.append(" PRIMARY KEY ");
            }
            if (cm.isUnique()) {
                b.append(" UNIQUE ");
            }
            if (cm.isAutoIncrement()) {
                b.append(" AUTOINCREMENT ");
            }
            if (cnt < cols.size() - 1) {
                b.append(",");
            }
            b.append("\n");
            ++cnt;
        }
        for (IndexModel im : tm.getIndexes()) {
            if (!im.getUnique().booleanValue()) continue;
            Object str = ", UNIQUE ";
            str = (String)str + " (" + StringUtil.join(", ", im.getFields()) + ") ";
            b.append((String)str);
            b.append("\n");
        }
        b.append(")\n");
        return b.toString();
    }

    public List<String> createIndexes(String tableName) {
        ArrayList<String> l = new ArrayList<String>();
        TableModel tm = this.getModel().getTable(tableName);
        if (!tm.hasIndexes()) {
            return l;
        }
        for (IndexModel im : tm.getIndexes()) {
            Object sql = "CREATE ";
            if (im.getUnique().booleanValue()) {
                sql = (String)sql + " UNIQUE ";
            }
            sql = (String)sql + " INDEX ";
            sql = (String)sql + im.getName();
            sql = (String)sql + " ON ";
            sql = (String)sql + tm.getName();
            sql = (String)sql + " (";
            int x = 0;
            while (x < im.getFields().size()) {
                if (x > 0) {
                    sql = (String)sql + ", ";
                }
                sql = (String)sql + im.getFields().get(x);
                ++x;
            }
            sql = (String)sql + " ) ";
            l.add((String)sql);
        }
        return l;
    }

    public String generateAddColumn(String tableName, ColumnModel cm) {
        String sql = "ALTER TABLE \"" + tableName + "\" ADD COLUMN \"" + cm.getName() + "\" " + this.dbtype(cm.getType());
        return sql;
    }

    public List<TableModel> updateSchema(SqlLiteConnection con) throws SQLException, IOException {
        TableModel tm;
        ArrayList<TableModel> updatedTables = new ArrayList<TableModel>();
        this.updateQueries = new ArrayList<String>();
        Map<String, TableModel> tablesModel = this.model.getTables();
        SqlDatabase sqlDb = this.buildSqlDatabaseModelOnly(con);
        for (String tblInModel : tablesModel.keySet()) {
            if (sqlDb.getTable(tblInModel) != null || !(tm = tablesModel.get(tblInModel)).isAutogenerated()) continue;
            String sqlCreate = this.generateCreateTable(tblInModel);
            this.updateQueries.add(sqlCreate);
            List<String> sqls = this.createIndexes(tblInModel);
            for (String sql : sqls) {
                this.updateQueries.add(sql);
            }
            if (updatedTables.contains(tm)) continue;
            updatedTables.add(tm);
        }
        for (SqlTable st : sqlDb.getTables()) {
            tm = tablesModel.get(st.getName());
            if (tm == null) continue;
            for (ColumnModel cm : tm.getColumns()) {
                if (st.getColumnByName(cm.getName().toLowerCase()) != null) continue;
                String sqlAdd = this.generateAddColumn(tm.getName(), cm);
                System.out.println(sqlAdd);
                this.updateQueries.add(sqlAdd);
                if (updatedTables.contains(tm)) continue;
                updatedTables.add(tm);
            }
        }
        for (String q : this.updateQueries) {
            AppLogger.log("Update query: " + q);
            con.query(q, new Object[0]);
        }
        return updatedTables;
    }

    public String trimQuotes(String s) {
        if (s.startsWith("\"") && s.endsWith("\"") && s.length() > 1) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    public SqlDatabase buildSqlDatabaseModelOnly(SqlLiteConnection con) throws IOException, SQLException {
        SqlDatabase db = new SqlDatabase();
        for (TableModel tm : this.model.getTables().values()) {
            List recs = con.queryList("select * from sqlite_master where type='table' and tbl_name = ?", tm.getName());
            if (recs.size() <= 0) continue;
            String n = this.trimQuotes(((BaseStringMap)recs.get(0)).getProperty("tbl_name"));
            String sql = ((BaseStringMap)recs.get(0)).getProperty("sql");
            SqlTable st = this.buildSqlTableWithSql(sql);
            db.addTable(st);
        }
        return db;
    }

    public SqlDatabase sqliteToSqlDatabase(SqlLiteConnection con) throws IOException, SQLException {
        List records = con.queryList("select * from sqlite_master where type='table'", new Object[0]);
        SqlDatabase db = new SqlDatabase();
        for (BaseStringMap rec : records) {
            String tbl = rec.getProperty("tbl_name");
            String sql = rec.getProperty("sql");
            SqlTable table = this.buildSqlTableWithSql(sql);
            db.addTable(table);
        }
        return db;
    }

    protected SqlTable buildSqlTable(SqlLiteConnection con, String tblName) throws IOException, SQLException {
        List records = con.queryList("select * from sqlite_master where type='table' and tbl_name = ?", tblName);
        if (records.size() > 0) {
            String sql = ((BaseStringMap)records.get(0)).getProperty("sql");
            return this.buildSqlTableWithSql(sql);
        }
        return null;
    }

    protected SqlTable buildSqlTableWithSql(String sql) throws IOException {
        CreateSqlParser p = new CreateSqlParser();
        p.parseSql(sql);
        List<SqlColumn> cols = p.getColumns();
        for (SqlColumn c : cols) {
            String t = this.dbtype(c.sqlDatatype);
            c.internalType = "bool".equals(t) || "boolean".equals(t) ? SqlColumn.DataType.BOOLEAN : ("INTEGER".equals(t) ? SqlColumn.DataType.NUMERIC : ("REAL".equals(t) ? SqlColumn.DataType.REAL : SqlColumn.DataType.TEXT));
        }
        SqlTable t = new SqlTable(p.getTableName());
        t.setColumns(cols);
        return t;
    }

    public String dbtype(String modelType) {
        if ((modelType = modelType.toLowerCase()).startsWith("varchar") || "text".equals(modelType) || "longtext".equals(modelType)) {
            return "TEXT";
        }
        if ("bool".equals(modelType) || "boolean".equals(modelType)) {
            return "INTEGER";
        }
        if ("int".equals(modelType) || "int32".equals(modelType) || "int64".equals(modelType) || "bigint".equals(modelType) || "long".equals(modelType)) {
            return "INTEGER";
        }
        if ("double".equals(modelType) || "float".equals(modelType)) {
            return "REAL";
        }
        if ("blob".equals(modelType)) {
            return "BLOB";
        }
        return "text";
    }

    public static void main(String[] args) {
        String s = "\"blabla\"";
        if (s.startsWith("\"") && s.endsWith("\"") && s.length() > 1) {
            s = s.substring(1, s.length() - 1);
        }
        System.out.println("s: " + s);
    }
}

