/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.llm;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import jtbcore.llm.OllamaResponse;
import jtbcore.util.FileUtil;
import jtbcore.util.RequestUrl;

public class OllamaChat {
    protected String chatUrl = "http://localhost:11434/api/chat";

    public String getChatUrl() {
        return this.chatUrl;
    }

    public void setChatUrl(String chatUrl) {
        this.chatUrl = chatUrl;
    }

    public OllamaResponse chat(String prompt, File img) throws Exception {
        ArrayList messages = new ArrayList();
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("role", "user");
        m.put("content", prompt);
        ArrayList<String> images = new ArrayList<String>();
        String imgdata = FileUtil.file2base64(img);
        images.add(imgdata);
        m.put("images", images);
        messages.add(m);
        LinkedHashMap<String, Object> c = new LinkedHashMap<String, Object>();
        c.put("model", "llama3.2-vision");
        c.put("messages", messages);
        c.put("stream", false);
        ObjectMapper om = new ObjectMapper();
        String reqdata = om.writeValueAsString(c);
        RequestUrl u = new RequestUrl(this.chatUrl);
        u.setRequestHeader("Content-type", "application/json");
        Integer contentLength = reqdata.length();
        u.setRequestHeader("Content-Length", contentLength.toString());
        u.setRequestData(reqdata);
        u.setReadTimeout(0);
        u.post();
        ObjectMapper mapper = new ObjectMapper();
        OllamaResponse r = (OllamaResponse)mapper.readValue(u.getResponseData(), OllamaResponse.class);
        return r;
    }

    public static void main(String[] args) {
        try {
            OllamaChat c = new OllamaChat();
            System.out.println("Start: " + String.valueOf(new Date()));
            OllamaResponse r = c.chat("print text in image as plain text, exact as it is, no translation, no additional texts", new File("/home/timvw/projects/ocr/bla3.jpg"));
            System.out.println(r.message.content);
            System.out.println("Done: " + String.valueOf(new Date()));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

