/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jtbcore.util.ProcUtil;

public class AppLogger {
    protected SimpleDateFormat sdf_hms = new SimpleDateFormat("HH:mm:ss");
    protected static AppLogger instance = null;
    protected List<AppLoggerListener> listeners = new ArrayList<AppLoggerListener>();
    protected String logfolder;
    protected String currentLogfolder = null;
    protected OutputStream outputStream = null;
    protected String eol = "\n";

    public AppLogger() {
        if (ProcUtil.isWindows()) {
            this.eol = "\r\n";
        }
    }

    public void addListener(AppLoggerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(AppLoggerListener l) {
        this.listeners.remove(l);
    }

    public synchronized String timestamp() {
        return this.sdf_hms.format(new Date());
    }

    public void _log(String s, Exception ex) {
        this._log(s);
        if (ex != null) {
            this.writeLog(this.exception2string(ex));
        }
    }

    public void _log(String s) {
        String line = "[" + this.timestamp() + "] " + s;
        System.out.println(line);
        this.writeLog(line);
        for (AppLoggerListener l : this.listeners) {
            l.logMessage(s);
        }
    }

    public void _error(String s, Exception ex) {
        this._error(s);
        if (ex != null) {
            this.writeLog(this.exception2string(ex));
        }
    }

    public void _error(String s) {
        String line = "[" + this.timestamp() + "] " + s;
        System.err.println(line);
        this.writeLog(line);
        for (AppLoggerListener l : this.listeners) {
            l.logError(s);
        }
    }

    public static void log(String s) {
        AppLogger.getInstance()._log(s);
    }

    public static void log(String str, Exception ex) {
        AppLogger.getInstance()._log(str + ": " + ex.toString());
    }

    public static void error(String s) {
        AppLogger.getInstance()._error(s);
    }

    public static void error(String str, Exception ex) {
        AppLogger.getInstance()._error(str + ": " + ex.toString(), ex);
    }

    public static void error(String str, Throwable thr) {
        String errmsg = thr != null ? thr.toString() : "null";
        AppLogger.getInstance()._error(str + ": " + errmsg);
    }

    public String exception2string(Exception ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.close();
        StringBuilder b = new StringBuilder();
        b.append("Error: ");
        b.append(ex.getMessage());
        b.append("\n");
        b.append(sw.toString());
        try {
            sw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return b.toString();
    }

    public void setLogFolder(String f) {
        this.logfolder = f;
        this.initFilelog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeLog(String s) {
        AppLogger appLogger = this;
        synchronized (appLogger) {
            if (this.outputStream != null) {
                try {
                    this.outputStream.write(s.getBytes());
                    this.outputStream.write(this.eol.getBytes());
                }
                catch (IOException e) {
                    this.outputStream = null;
                    System.out.println("Error writing to log: " + e.getMessage());
                    System.out.println("Logging stopped");
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initFilelog() {
        if (this.logfolder == null || this.logfolder.trim().length() == 0) {
            this._closeLog();
            return;
        }
        File f = new File(this.logfolder);
        if (!f.exists() || !f.isDirectory()) {
            this._closeLog();
            return;
        }
        if (this.outputStream != null && this.currentLogfolder != null && this.currentLogfolder.equals(this.logfolder)) {
            this._closeLog();
            return;
        }
        AppLogger appLogger = this;
        synchronized (appLogger) {
            if (this.outputStream != null) {
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.outputStream = null;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            String file = f.getAbsolutePath() + File.separator + "eo-" + sdf.format(new Date()) + ".log";
            try {
                this.outputStream = new FileOutputStream(new File(file), true);
            }
            catch (FileNotFoundException e) {
                System.out.println("Error creating logfile: " + file);
                e.printStackTrace();
            }
            this.currentLogfolder = this.logfolder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _closeLog() {
        AppLogger appLogger = this;
        synchronized (appLogger) {
            if (this.outputStream != null) {
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.outputStream = null;
            }
        }
    }

    public static void closeLog() {
        instance._closeLog();
    }

    public static AppLogger getInstance() {
        if (instance == null) {
            instance = new AppLogger();
        }
        return instance;
    }

    public static interface AppLoggerListener {
        public void logMessage(String var1);

        public void logError(String var1);
    }
}

