
import { appConfig } from '../service/AppConfig.js';


export class MenuWidget {
	
	tpl = `
		<div>
			<ul class="menu-items">
				<li class="burger-menu"><a href="javascript:void(0);" [widget]="widget" onclick="widget.toggleMobileMenu();" class="fas fa-bars"></a></li>
				
				<li ez-forme="menuItems" ez-item="mi">
					<a href="{{appUrl(mi.url)}}">{{mi.label}}</a>
				</li>
			</ul>
		</div>
	`;
	
	mobileMenuClosed = true;
	
	menuItems = [];
	
	
	init( e ) {
//		console.log(e);
		this.initMenuItems();
		
		let et = new EzTemplate( e );
		et.loadHtml( this.tpl );
		et.setObject('widget', this);
		et.setVar('isAdmin', toolboxConfig.admin);
		et.setVar('menuItems', this.menuItems);
		et.build();
		et.render();
		
		window.addEventListener('popstate', function() {
			this.updateMenu();
		}.bind(this));
		
		$(window).on('window-history-pushed', function() {
			this.updateMenu();
		}.bind(this));
		
		this.updateMenu();
		
		$('.menu-items li:not(.burger-menu)').click(function() {
			$('.menu-items').removeClass('show-mobile');
		}.bind(this));
		
		this.handleLogoff();
	}
	
	initMenuItems() {
		
		
		this.menuItems = [];
		this.menuItems.push( { sort:  100, url: '/', 							label: 'Dashboard' } );
		this.menuItems.push( { sort:  200, url: '/customers/', 					label: 'Relaties' } );
//		this.menuItems.push( { sort:  300, url: '/sales/rental/', 				label: 'Verhuur' } );
//		this.menuItems.push( { sort:  310, url: '/sales/rental/occupation/', 	label: 'Verhuur - Bezetting' } );
//		this.menuItems.push( { sort:  320, url: '/sales/offer/', 				label: 'Offertes' } );
//		this.menuItems.push( { sort:  330, url: '/sales/order/', 				label: 'Orders' } );
//		this.menuItems.push( { sort:  340, url: '/sales/invoice/', 				label: 'Facturatie' } );
//		this.menuItems.push( { sort:  400, url: '/contracts/', 					label: 'Contracten' } );
//		this.menuItems.push( { sort:  450, url: '/contracts/tasks/', 			label: 'Contract taken' } );

		if (appConfig.isAdmin())
			this.menuItems.push( { sort:  900, url: '/email/', 						label: 'E-mail' } );
		
		this.menuItems.push( { sort: 1000, url: '/files/', 						label: 'Bestanden' } );
		
		if (toolboxConfig.admin) {
			this.menuItems.push( { sort: 100000, url: '/masterdata/', label: 'Instellingen' } );
		}
		
		this.menuItems = apply_filter( 'MenuWidget.menuItems', this.menuItems );
		
		this.menuItems.sort((o1, o2) => {
			return o1.sort - o2.sort;
		});
	}
	
	handleLogoff() {
		if (itxapp.config.userId) {
			$('.logoff-container').removeClass('hidden');
			
			$('#logoff').on('click', function() {
				
				showConfirmation('Afmelden', 'Weet je zeker dat je je wilt afmelden? <label class="signout-all"><input type="checkbox" id="logoffAllSessions" /> <span>Alle sessies afmelden</span></label>', function() {
					
					postUrl( '/service/auth.do', {
						a: 'logoff',
						allsessions: $('#logoffAllSessions').prop('checked') ? 1 : 0
					}).then( async function(e) {
						window.location = appUrl('/');
					});
					
				}.bind(this));
			});
		}
	}
	
	
	updateMenu() {
		$('.menu-items').find('.selected').removeClass('selected');
		
		let pathname = window.location.pathname;
		
		// lookup url with largest href-match :)
		let matchLen = -1;
		let lastMatch = null;
		$('.menu-items').find('a').each(function(index, node) {
			let href = $(node).attr('href');
			
			if ( pathname.startsWith(href) ) {
				if (href.length > matchLen) {
					matchLen = href.length;
					lastMatch = node;
				}
			}
		});
		
		if (lastMatch)
			$(lastMatch).closest('li').addClass('selected');
	};
	
	toggleMobileMenu() {
		if ( $('.menu-items').hasClass('show-mobile') ) {
			$('.menu-items').removeClass('show-mobile');
		}
		else {
			$('.menu-items').addClass('show-mobile');
		}
	}
	
}


