
loadCss( '/static/app/widget/email/css/email.css' );




export class EmailViewWidget {

	tpl = `
		<div class="page-header" ez-if="showHeader">
			<div class="toolbox">
				<a href="{{appUrl('/email/')}}" class="fa fa-chevron-circle-left"></a>
				
				<a href="javascript:void(0);" [onclick]="widget.edit_Click" class="fa fa-pencil"></a>
			</div>
			
			<h1>{{ _('View e-mail') }}</h1>
		</div>
		
		<div id="email-view">
		
			<div class="email-files">
				{{ _('Files') }}
				
				<div ez-if="email.files.length == 0" style="margin-top: 15px; font-style: italic;">
					{{_('No attachments') }}
				</div>
				
				<ul ez-for="email.files" ez-item="file">
					<li file-id="{{file.emailFileId}}">
						<a href="javascript:void(0);" [onclick]="widget.openFile">{{file.filename}}</a>
					</li>
					
				</ul>
			</div>
			
			
			<table>
				<tr>
					<th>Id</th>
					<td>
						{{email.emailMessageId ?? 'Nieuwe e-mail'}}
					</td>
				</tr>
				<tr>
					<th>Van</th>
					<td>{{ email.fromName }} &lt;{{email.fromEmail}}&gt;</td>
				</tr>
				<tr>
					<th>Status</th>
					<td>{{ _('emailStatus.'+email.status) }}</td>
				</tr>
				<tr ez-if="email.customerId != null">
					<th>Klant</th>
					<td>
						<a href="javascript:void(0);" [onclick]="widget.gotoCustomer_Click">{{email.customerName}}</a>
					</td>
				</tr>
				<tr ez-forMe="email.tos" ez-item="to">
					<td>
						<b>{{ _('emailToType.'+to.toType) }}</b>
					</td>
					<td>
						{{ to.toName }}
						{{ to.toName && to.toEmail ? '-' : '' }}
						{{ to.toEmail }}
					</td>
				</tr>
				<tr>
					<th>Onderwerp</th>
					<td>
						{{ email.subject }}
					</td>
				</tr>
			</table>
			
			<hr/>
			<div [contentHTML]="email.textContent" class="mail-content"></div>
		</form>
		
	`;
	
	ezTpl = null;
	container = null;
	
	showHeader = true;
	
	email = {
		status: 'new',
		tos: [ {} ]
	};
	
	
	init(c) {
		this.container = c;
		
		this.loadEmail( getUrlParam('id') );
	}
	
	setContainer( c ) { this.container = c; }
	setShowHeader(bln) { this.showHeader = bln; }
	
	
	loadEmail(emailId) {
		console.log('loadEmail');
		
		return postUrl('/service/email/message.do', {
			emailMessageId: emailId,
			a: 'view'
		}).then( async (e) => {
			let json = await e.json();
			
			this.email = json.emailMessage;
			
			this.render();
		});
	}
	
	
	
	render() {
		
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.loadHtml( this.tpl );
		
		this.ezTpl.setVar('showHeader', this.showHeader);
		this.ezTpl.setVar('email', this.email);
		
		this.ezTpl.setObject('widget', this);
		
		this.ezTpl.render();
	}
	
	
	openFile(evt) {
		let fileid = $(evt.target).closest('li').attr('file-id');
		
		window.open( appUrl('/service/email/message.do?a=downloadFile&id=' + fileid), '_blank' );
	}
	
	gotoCustomer_Click() {
		gotoRoute('/customers/edit/?id=' + this.email.customerId)
	}
	
	
	edit_Click() {
		gotoRoute( '/email/edit/?id=' + this.email.emailMessageId );
	}
	
		
}


