

export class SampleFilePopup {
	
	tpl = `
		<div class="sample-file-popup" style="height:100%;">
			<div class="page-header">
				<div class="toolbox">
				<a href="javascript:void(0)" [onclick]="widget.removeFile_Click" class="fa fa-unlink"></a>
					
					<a href="javascript:void(0)" [onclick]="widget.close" class="fa fa-times-circle"></a>
				</div>
				<h1>{{file.originalFilename}}</h1>
			</div>
			
			<div ez-if="loading">
				Loading...
			</div>
			
			<div ez-if="!loading">
				<div class="action-box">
					<span><a [onclick]="widget.downloadFile_Click">{{_('Download file')}}</a></span>
					
					<span ez-if="showViewFile"><a [onclick]="widget.viewFile_Click">{{_('View file')}}</a></span>
				</div>
				
				<hr/>
				
				<div>
					{{file.originalFilename}} ({{bytes2human(file.size)}}) - {{format_datetime(file.created, {dmy: true})}}
					
					<div ez-if="file.note != null && file.note.length > 0">
						<div class="note-header">{{_('Note')}}</div>
						{{file.note}}
					</div>
				</div>
				
				<div class="sample-container" style="margin-top: 25px;"></div>
			</div>
		</div>
	`;
	
	container = null;
	
	file = null;
	
	callback_removeFile = null;
	showViewFile = false;
	
	loading = true;
	
	constructor(file) {
		this.file = file;
	}
	
	
	setCallbackRemoveFile( callback ) {
		this.callback_removeFile = callback;
	}
	
	
	downloadFile_Click() {
		window.location = appUrl('/service/files.do?a=downloadFile&dbFileId=' + this.file.dbFileId);
	}
	
	viewFile_Click() {
		let u = appUrl('/service/files.do?a=downloadFile&inline=1&dbFileId=' + this.file.dbFileId);
		
		window.open( u, '_blank' );
	}
	
	removeFile_Click() {
		this.callback_removeFile( this.file );
		this.close();
	}
	
	
	close() {
		close_popup();
	}
	
	async load() {
		let r = await postJson('/service/files.do', {
			a: 'view',
			dbFileId: this.file.dbFileId
		});
		
		let json = await r.json();
		
		this.file = json.file;
		
		let ext = file_extension(this.file.originalFilename);
		if (['png', 'gif', 'jpg', 'jpeg', 'pdf'].indexOf(ext) != -1) {
			this.showViewFile = true;
		}
		
		this.loading = false;
		
		this.render();
	}
	
	
	showPopup() {
		if (this.container == null)
			this.container = show_popup('View file', '');
		
		this.render();
		
		this.load();
	}
	
	render() {
		
		let eztpl = new EzTemplate( this.container );
		eztpl.loadHtml( this.tpl );
		eztpl.setObject('widget', this);
		eztpl.setVar('file', this.file);
		eztpl.setVar('loading', this.loading);
		eztpl.setVar('showViewFile', this.showViewFile);
		
		eztpl.setVar('showRemoveFile', this.callback_removeFile != null ? true : false);
		
		eztpl.render();
		
		if ( this.loading == false ) {
			this.renderSample();
		}
	}
	
	renderSample() {
		
		let ext = file_extension( this.file.originalFilename );
		
		if (ext == 'pdf') {
			let d = document.createElement('div');
			
			d.innerHTML = '<embed width="100%" style="height: 800px;" type="application/pdf">';
			
			document.querySelector('.sample-file-popup .sample-container').appendChild( d );
			
			$(d).find('embed').attr('src', appUrl('/service/files.do?a=downloadFile&inline=1&dbFileId=' + this.file.dbFileId));
		}
		
		if (ext == 'png' || ext == 'jpg' || ext == 'jpeg' || ext == 'gif') {
			let d = document.createElement('div');
			d.style.textAlign = 'center';
			
			d.innerHTML = '<img style="max-width: 50%; height: auto;" />';
			
			document.querySelector('.sample-file-popup .sample-container').appendChild( d );
			
			$(d).find('img').attr('src', appUrl('/service/files.do?a=downloadFile&inline=1&dbFileId=' + this.file.dbFileId));
		}
		
		
	}
	
	
}

